;~   ~   ~   ~   ~   ~  ~   ~   ~   ~   ~   ~ 
; extreme v9.0
; startup and check-up routines
;
;~   ~   ~   ~   ~   ~  ~   ~   ~   ~   ~   ~  
;
;startup sequence
on *:START:{
  .timer 1 0 _startup start
  _startlogo
}
on *:LOAD:._startup load.all

alias -l _startup {

  ;version checking
  if ($version < 6.17) { sr -th Error This script can only be used with mIRC32 v6.17+ | .timer 1 2 exit | halt }
  if ($bits != 32) { sr -th Error This script can only be used with mIRC 32bits. | .timer 1 2 exit | halt }

  ;load settings
  loadallhash

  ;load users
  loadallusr

  if ($hget(x_status,actual.mircver) != $version) {
    _set status actual.mircver $version
  }

  ;first run sequence
  if (%.first.run) {
    var %r = $readini(system\upgrade.mrc,patch,r)
    if (%r isnum) {
      _set status lastnews %r
      _set status patch %r
      remini system\upgrade.mrc patch
    }
    .timer 1 5 sr -t Welcome Welcome to eXtreme script $lf $+ Please take the time to set up the script
    .timer 1 8 _first
  }

  ;script integrity checking
  ._scriptcheck $1

  ;reset
  _reset start

  ;starts counter, and auto-backup system
  var %starts = $calc($hget(x_status,starts) +1)
  _set status starts %starts
  var %pstarts = $iif($hget(x_sets,auto.backup.starts) isnum,$ifmatch,30)
  if (%pstarts // %starts) && (%pstarts != 0) && ($hget(x_sets,noautobackup) != 1) hlist 1 system\extreme.ini 1

  ;check recent topics list
  if ($lof(system\topics.ini) > 60000) _deltopicsini

  ;check seen list
  if ($hget(x_sets,seen.status)) && ($hget(x_sets,seen.max)) && ($hget(x_sets,seen.max) <= $hget(x_seen,0).item) {
    var %d = $int($calc($iif($hget(x_sets,seen.duration) isnum 1-365,$ifmatch,90) /2))
    .timer 1 0 _cleanoldseens %d
  }

  if ($hget(x_sets,get.drives)) getdrives

  _lockrun
  _lockdll

  _set ctcps motfv 0
  if (!$lock(dll)) {
    if ($gettok($dll(dlls\motfv3.dll,motfv,Load),1,32) == ok) _set ctcps motfv 1
    mdx SetMircVersion $version
  }

  _lagbar
  event.sound startup
  script
  linesep

  if ($hget(x_sets,get.news)) _set vars get.news 1
  if ($hget(x_perform,on_start)) _perfd $ifmatch

  _upg

  .timer 1 2 .timerglbtimer -i 0 $iif($hget(x_sets,titlebar.time) isnum,$ifmatch,2) _glbtimer

  if ($1 == start) {
    _startlogo
    ;.timer 1 0 sr -t Important This is a BETA version, many features are yet to be added/finished.
  }

}

;/getdrives (retrieves local drives)
alias getdrives {
  _unset sets drives
  var %n = 99
  while (%n <= 122) {
    var %l = $chr(%n) $+ :
    if ($disk(%l)) var %d = $addtok(%d, [ $upper(%l) $+ \ ] ,44)
    inc %n
  }
  _set sets drives %d
}

alias _scriptcheck {

  if ($1 == load.all) {
    echo -s *** Loading all aliases,remotes and popups
    var %load = 1
  }
  ;checking aliases
  var %n = 1, %f, %l = $a.files
  while ($gettok(%l,%n,44)) {
    var %s = $ifmatch
    if (!$alias(%s)) {
      if ($isfile($+(system\,%s))) .load -a system\ $+ %s
      if (!$alias(%s)) { %f = 1 | echo -s *** Error: missing alias file %s $+ , failed to reload (file not found) }
    }
    inc %n
  }

  ;checking remotes
  var %n = 2, %l = $r.files
  while ($gettok(%l,%n,44)) {
    var %s = $ifmatch
    if (!$script(%s)) {
      if ($isfile($+(system\,%s))) .reload -rs $+ %n system\ $+ %s
      if (!$script(%s)) { %f = 1 | echo -s *** Error: missing remote file %s $+ , failed to reload (file not found) }
    }
    inc %n
  }

  ;checking popups, vars, users
  var %n = 1, %l = $p.files
  while ($gettok(%l,%n,44)) {
    var %s = system\ $+ $ifmatch, %e = $mid(%s,9,1)
    if ($isfile(%s)) .load -p $+ %e %s
    else %f = 1
    inc %n
  }
  if ($isfile(system\remote.ini)) {
    .load -ru system\remote.ini
    .load -rv system\remote.ini
  }

  if (%f) {
    echo -s *** Fatal error: some file(s) appear to be missing from system\ dir. You should reinstall the latest patch, or the whole script.
    linesep
  }
  else echo -qs *** All files OK

  if (!$isdir(config)) || ($hget(0) < 15) {
    if ($isfile(system\extreme.ini)) { echo -s *** Error: settings may be missing... attempting to reload | .ini2hash }
    else echo -s *** Warning: Configuration files are missing and main backup file (system\extreme.ini) couldn't be found
  }
  if (!$isdir(tmp)) mkdir tmp | _+
  if (!$isdir(config\profiles)) mkdir config\profiles

  ;this will remove old themes not correctly unloaded
  var %a = 1
  while ($alias(%a)) {
    var %f = $ifmatch, %file = $nopath($ifmatch)
    if (*.thm iswm %file) && ($nopath($hget(x_display,theme)) != %file) .unload -a $+(",$alias(%a),")
    inc %a
  }
  if (%load) {
    echo $color(info) -qs *** Success. Script is now ready
    .unload -a aliases.ini
    .unload -rs script.ini
    .reload -rs1 system\start.mrc
  }
}

alias _reset {
  if ($__i(ret.nick) isnotify) .notify -r $__i(ret.nick)
  if (ChanServ isnotify) .notify -r ChanServ
  .rlevel -r 20

  if (*!*@* isignore) .ignore -r *!*@*
  _checkownignore reset

  var %t = $numtok($__i(clearthis),32)
  while (%t) {
    if ($gettok($__i(clearthis),%t,32) isignore) .ignore -r $ifmatch
    dec %t
  }
  if ($__i(blockpvt)) && ($hget(x_sets,blocked.keep.settings)) _set sets blocked $__i(blockpvt)

  if ($__i(away.mynick)) .nick $ifmatch
  if ($__i(awaysince)) && ($hget(x_away,keep.away)) {
    _set away away $__i(awaysince) $iif($__i(awaylog),$ifmatch,-) $__i(awayreason)
  }

  if ($1 == start) {
    if (%first.run) {
      unset %first.run
      set %.first.run 1
      if ($server) quit rehashing
      .timer 1 2 exit
      sr -t Warning Exiting...
    }
    .enable #extreme.*
    if ($hget(x_display,timestamp)) .timestamp -f $ifmatch
    if ($hget(x_wins,save.tome.reset)) _remove logs\@*.txt
    _unset status install.patch
    _remove tmp\*
    _remove $logdirspamlog*.log
    _unset tempbans
    unset %.*
    _hfree x_vars
    hfree -w x_tmp-*
  }
  else {
    window -c $+(@infolog,$_@network)
    .remove $+(",$logdirspamlog,$_network,.log")
    if ($hget(x_wins,save.tome.reset)) _remove $+(logs\@*,$_network,.txt)

    var %n = 1
    while ($window(%n)) {
      var %w = $ifmatch
      if ($window(%n).cid == $cid) && (%w != @tb.lagbar) window -c %w
      inc %n
      if ($hget(x_vars)) hdel -w x_vars $+(*.cid,$cid)
      hfree -w $+(x_tmp-cid,$cid,-*)
      unset $+(%,.cid,$cid,.*)
    }
    if ($timestampfmt) _-set display timestamp $ifmatch
  }
}

;/_resetdef (resets the script to it's default settings)
alias _resetdef {
  if ($input(This will reset all settings to their default. $+ $crlf $+ You will loose some of your lists (except userlist and notify). $+ $crlf $+ Are you sure?,yw,Reset)) {
    .ini2hash
    _reset
    sle All script settings have been set to their default
  }
}

alias _first {
  about
  .timer 1 3 setup
}

alias _deltopicsini {
  if ($input(Your 'recent topics' file is rather big (>64Kb). You should remove it. Do it now?,yw,RecTopics)) {
    .remove system\topics.ini
    ale 'Recent topics' file has been removed
  }
}

;/backup (exports settings to an ini file)
alias backup hlist 1 $$_input(Enter filename,e,Backup,backup.ini)
;/restore (restores settings from an ini file)
alias restore _impconfig $shortfn($$sfile(*.ini,Select .ini file))
;/panic (attempts to restore the script's files and settings)
alias panic .load -rs system\start.mrc | _impconfig system\extreme.ini

alias list.rfiles {
  var %n = 1, %list
  while ($script(%n)) {
    %list = $addtok(%list,$nopath($ifmatch),44)
    inc %n
  }
  if (%list) echo -s %list
}

alias r.files return start.mrc,raws.mrc,events1.mrc,events2.mrc,events3.mrc,ctcp-dcc.mrc,text.mrc,disp1.mrc,disp2.mrc,disp3.mrc,disp4.mrc,userlist.mrc,seen.mrc,protect1.mrc,protect2.mrc,protect3.mrc,awaysys.mrc,network.mrc,setup.mrc,sysdlgs.mrc,miscdlg.mrc,menus.mrc,sounds.mrc,language.mrc,profiles.mrc,email.mrc,tcpip.mrc,games.mrc,spambot.mrc
alias a.files return a-idents.mrc,a-chan.mrc,a-text.mrc,a-misc.mrc
alias p.files return pstatus.pop,pchannel.pop,pnicklist.pop,pquery.pop,pmenubar.pop

;/_lockrun and /_lockdll (check if /run or /dll are enabled)
alias _lockrun {
  if ($lock(run)) {
    if ($isid) return 1
    else sr Command /run is disabled. $+ $crlf $+ Please enable it in mIRC's General options
  }
}
alias _lockdll {
  if ($lock(dll)) {
    if ($isid) return 1
    elsesr Command /dll is disabled. $+ $crlf $+ Please enable it in mIRC's General options
  }
}


;/_remove <path\mask-file1,file2,...> (removes all files according to mask, except for the ones specified)
alias _remove {
  var %1 = $gettok($1-,1,45), %2 = $gettok($1-,2,45), %p = $nofile(%1), %f = $nopath(%1), %d = $findfile(%p,%f,0,if (!$istok(%2,$nopath($1-),44)) .remove $+(",$1-,"))
}

;/__remove <dir> <file1,file2,...> (removes a list of comma separated files)
alias __remove {
  var %n = 1
  while (%n <= $numtok($2-,44)) {
    .remove $1 $+ $gettok($2-,%n,44)
    inc %n
  }
}

;/_rmdir [-d] <path> [1] (removes all files and subfolders in folder. If [-d] it also removes the folder)
alias _rmdir {
  if (-* iswm $1) var %sw = $2, %path = $2-
  else var %path = $1-
  if (!$exists(%path)) return
  var %a = $finddir(%path,*,0,__rmdir $1-)
  if (%::rmdir) {
    var %n = $numtok(%::rmdir,44)
    while ($gettok(%::rmdir,%n,44)) {
      .rmdir $+(",$ifmatch,")
      dec %n
    }
  }
  _remove %path $+ \*
  if (%sw == -d) .rmdir $+(",%path,")

}
alias -l __rmdir {
  _remove $1- $+ \*
  set -u %::rmdir $addtok(%::rmdir,$shortfn($1-),44)
}

alias _v return $remove($+(%,.,$1-),$chr(32))
alias __v return $eval($_v($1-),2)

alias _i return $remove($+(%,.cid,$cid,.,$1-),$chr(32))
alias __i return $eval($_i($1-),2)

alias _rand6 return $rand(a,z) $+ $rand(a,z) $+ $rand(0,9) $+ $rand(0,9) $+ $rand(a,z) $+ $rand(a,z)

;=============================================
; hashtables stuff

/_set and /_unset <table> <item>; both add/del from an hash table AND update it's file
alias _set {
  var %1 = $+(x_,$1)
  if ($3 != $null) {
    hadd -m %1 $2-
    _hsave %1
  }
  else _unset $1-2
}
alias _unset {
  var %1 = $+(x_,$1)
  if ($hget(%1)) {
    if ($2 != $null) hdel %1 $2-
    else hfree %1
    _hsave %1
  }
}
;....
alias _echo.myaddress {
  if ($__i(myaddress)) {
    .timermask. $+ $cid off
    sle Connected as: $__i(myaddress) $iif($ip,( $+ $ip $+ ))
  } 
}

;----

/_-set and /_-unset <table> <item>; both add/del from an hash table, don't update it's file but add it's name to a update list (good for configuration dialogs)
alias _-set {
  var %1 = $+(x_,$1)
  if ($3 != $null) {
    hadd -m %1 $2-
    hadd -m x_vars hupd $addtok($hget(x_vars,hupd),%1,44)
  }
  else _--unset $1 $2
}
alias _-unset {
  var %1 = $+(x_,$1)
  if ($hget(%1)) {
    if ($2 != $null) hdel %1 $2-
    else hfree %1
    hadd -m x_vars hupd $addtok($hget(x_vars,hupd),%1,44)
  }
}
;...

/_--set and /_--unset <table> <item>; both add/del from an hash table but doesn't update the file. faster than all above.
alias _--set {
  var %1 = $+(x_,$1)
  if ($3 != $null) hadd -m %1 $2-
  else _--unset $1 $2
}
alias _--unset {
  var %1 = $+(x_,$1)
  if ($hget(%1)) {
    if ($2 != $null) hdel %1 $2-
    else hfree %1
  }
}
;/_hfree <table> same as /hfree, but it checks if the table exists
alias _hfree if ($hget($1)) hfree $1

;/_var <item> <value> good for keeping temp vars (global)
alias _var {
  ;  if ($cid) var %t = $+(x_vars.cid,$cid)
  ;  else var %t = x_vars
  var %t = x_vars
  if ($2 != $null) hadd -m %t $1-
  elseif ($hget(%t,$1)) hdel %t $1
}

;$__var(item) <table> <item> good for keeping temp vars (global)
alias __var {
  ;  if ($cid) var %t = $+(x_vars.cid,$cid)
  ; else var %t = x_vars
  ; if ($1 != $null) return $hget(%t,$1)

  if ($1 != $null) return $hget(x_vars,$1)
}

;$_protset(chan,setting)
alias _protset {
  ; var %r = $dll(dlls\aircdll.dll, FloodOptGets, $1 +c $2)
  ;  if (+* iswm %r) return $gettok(%r,2-,32)

  var %cache = $+(x_tmp-cid,$cid,-cache), %i = $+(cset.,$2,.,$1), %res
  if ($hget(%cache,%i) != $null) return $ifmatch
  if ($hget($+(x_prot-,$mkfn($2)),$1) != $null) %res = $ifmatch
  else %res = $hget(x_prot,$1)
  hadd -mu5 %cache %i %res
  return %res
}

alias hlist {
  if ($hget(0) == 0) return
  var %n = 1, %i, %c, %win = @HashEditor
  if ($1) {
    var %file = $iif($2,$2,backup.ini)
    %c = write %file
    write -c %file
    _whlist
  }
  else {
    window -nkl -t60 @HashEditor @hash $_@font
    clear %win
    %c = aline %win
  }
  _pwait 0 $hget(0) $iif($1,Creating backup file...,Reading hashtables...)


  var %w1 = @_hlist- $+ $rand(111,999), %h = 1, %nchr = $chr(9)
  window -hls %w1
  while (%h <= $hget(0)) {
    aline %w1 $hget(%h)
    inc %h
  }
  var %total = $line(%w1,0)
  while (%n <= %total) {
    var %hgetn = $line(%w1,%n), %table = $_fmt2(%hgetn)
    _pwait %n %total

    ;some tables are not saved in backup file
    if (%file) && ((x_* !iswm %hgetn) || (%hgetn == x_vars) || (%hgetn == x_seen) || (%hgetn == x_mp3list) || (x_tmp-* iswm %hgetn)) goto next

    if (%hgetn == x_mp3list) goto next

    %c [[ $+ %table $+ ]]
    %i = 1
    while (%i <= $hget(%hgetn,0).item) {
      var %item = $hget(%hgetn,%i).item, %data = $hget(%hgetn,%item)

      if (%file) %c %item $+ = $+ $replace(%data,$chr(1),<chr(1)>,,<k>,,<u>,,<b>,,<r>)
      else %c %item $+ = $+ %data
      inc %i
    }
    :next
    inc %n

    %c $iif($1,$cr,%nchr)
  }
  window -c %w1
  if ($window(%win)) {
    titlebar %win ( $+ %total tables)
    window -a %win
  }
  _pwait

  if (%file) && ($3 != 1) sr INI file created $+ $crlf $+ $gettok(%c,2-,32)
}

alias _hclear hfree -w x_*

/ini2hash loads hashtables from an .ini file
alias ini2hash {
  _hclear
  var %n = 1, %f = $iif($1,$1,system\extreme.ini), %l, %dir = $iif($2,$2,config)
  if (!$isdir(%dir)) mkdir %dir
  while (%n <= $ini(%f,0)) {
    _pwait %n $ini(%f,0) $iif($2,Creating profile...,Importing settings...)
    var %s = $ini(%f,%n), %r = $ini(%f,%s,0), %i = 1
    if (%r) {
      var %table = $_fmt(%s)
      if (!%table) goto next1
      hmake %table 10
      while (%i <= %r) {
        %l = $ini(%f,%s,%i)
        var %e = $readini(%f,%s,%l)
        hadd %table %l $replace(%e,<chr(1)>,$chr(1),<k>,,<u>,,<r>,,<b>,)
        inc %i
      }
    }
    :next1
    inc %n
  }
  if ($2) set %profile %dir
  saveallhash
  _pwait
  if ($show) sr -t Info Import completed
}

alias _fmt {
  if (x_* iswm $1) return $1
  return x_ $+ $1
}
alias _fmt2 {
  if (x_* iswm $1) return $right($1,-2)
  return $1
}

alias hfix return $replace($1-,,&k,,&b,,&u,,&r)
alias hufix return $replace($1-,&k,,&b,,&u,,&r,)


alias saveallhash {
  clearallhash
  var %n = 1, %path = $iif($isdir(%profile),%profile,config\)
  _hfree hashsizes
  while (%n <= $hget(0)) {
    var %hget = $hget(%n)
    if (x_* iswm %hget) && (x_tmp-* !iswm %hget) && (!$istok(x_hashsizes.x_vars,%hget,46)) {
      var %file = $_fmt2(%hget) $+ .hsh, %size = $hget(%n,0).item
      if (%size) {
        hadd -m x_hashsizes %hget $ifmatch
        hsave -o $hget(%n) $+(%path,%file)
      }
      else .remove $+(%path,%file)
    }
    inc %n
  }
  if ($hget(x_hashsizes)) hsave -o $ifmatch $+(%path,hashsizes.hsh)
  _hfree x_servers
}

alias loadallhash {
  _hclear
  var %path = $iif($isdir(%profile),%profile,config\)
  if ($isfile($+(%path,hashsizes.hsh))) {
    hmake x_hashsizes 5
    hload x_hashsizes $shortfn($+(%path,hashsizes.hsh))
  }
  var %l = $findfile(%path,*.hsh,0,1,_loadhash2 $1-)
}
alias -l _loadhash2 {
  var %f = $1-, %t = $_fmt($remove($nopath(%f),.hsh)), %fsize = $file(%f).size
  if (%fsize == 0) .remove %f
  elseif (!$istok(x_servers.x_hashsize,%t,46)) {
    _hfree %t
    var %len = $hget(x_hashsizes,%t)
    if (%len > 20000) var %size = 200
    elseif (%len > 1000) var %size = 100
    elseif (%len > 500) var %size = 30
    elseif (%len > 100) var %size = 20
    else var %size = 10
    hmake %t %size
    hload %t $shortfn(%f)
  }
}
;/clearallhash (deletes all *.hsh files, except for the servers.hsh)
alias clearallhash {
  var %path = $iif($isdir(%profile),%profile,config\)
  _remove %path $+ *.hsh-servers.hsh
}

;/_hsave (updates an hash table's file)
alias _hsave {
  var %path = $iif($isdir(%profile),%profile,config\), %file = $+(%path,$_fmt2($1),.hsh)
  if ($hget($1)) hsave -o $1 %file
  elseif ($1) .remove %file
  _hfree $+(x_tmp-cid,$cid,-cache)
}

;/hupd (same as above, for all tables queued for update)
alias hupd {
  var %n = 1
  while (%n <= $numtok($hget(x_vars,hupd),44)) {
    _hsave $gettok($hget(x_vars,hupd),%n,44)
    inc %n
  }
  _--unset vars hupd
}
;

;stuff for creating an hash list of servers, faster than retrieving with $server()
alias _hadd.servers {
  var %n = 1
  _hfree x_servers
  hmake x_servers 30
  while (%n <= $server(0)) {
    _pwait %n $server(0) Updating servers list...
    hadd x_servers %n $server(%n).group $+ : $+ $server(%n)
    inc %n
  }
  _hsave x_servers
  _pwait
}
alias _loadservers {
  _hfree x_servers
  var %path = $iif($isdir(%profile),%profile,config\)
  if ($isfile($+(%path,servers.hsh))) {
    hmake x_servers 30
    hload x_servers $+(%path,servers.hsh)
    if ($server(0) == $hget(x_servers,0).item) return
  }
  _hadd.servers
}

;=============================================
;import settings

alias _import {
  var %f = $nopath($1-)
  if (%f == mirc.ini) _impnotify $1
  if (%f == remote.ini) _impusers $1
  if (%f == extreme.ini) _impconfig $1
}

alias _impnotify {
  var %n = 0, %w = 1, %i = 0
  while (%w) {
    %w = $readini($1,notify,$+(n,%n))
    if (%w) { .notify $replace(%w,NOTE:,$chr(32)) | inc %i }
    inc %n
  }
  sle Imported %i notify entries.
  if ($2) _impusers $nofile($1) $+ system\remote.ini $2
}
alias _impusers {
  ;  var %n = 0, %w = 1, %i = 0
  ;  while (%w) {
  ;    %w = $readini($1,users,$+(n,%n))
  ;    if (%w) && (;* !iswm %w) { .auser -a $gettok(%w,1,58) $gettok(%w,2-,58) | inc %i }
  ;    inc %n
  ;  }
  ;  sle Imported %i user entries.
  var %a = $nofile($1) $+ address.ini
  if ($file(%a).size > 0) { .copy -o %a system\address.ini | sle Imported address.ini database }
  if ($2) {
    var %path = $iif($isdir(%profile),%profile,config\)
    if ($isdir($+($deltok($nofile($1),-1,92),$+(..\,%path)))) { .copy -o $+($deltok($nofile($1),-1,92),$+(..\,%path,*.hsh)) %path | loadallhash }
    else _impconfig $nofile($1) $+ extreme.ini $2
  }
}
alias _impconfig {
  if ($input(This will replace all your actual script settings (defined in the script's dialogs) $+ $crlf $+ Are you sure?,yw)) {
    .ini2hash $1
    sle Imported INI file.
    if ($xtreme.ver) writeini system\upgrade.mrc patch v $ifmatch
    if ($hget(x_status,patch)) writeini system\upgrade.mrc patch r $ifmatch
    if ($isalias(_upgrade)) _upgrade 1
  }
}
alias importall {
  sr -t Error Sorry, this feature is not yet available
  return

  var %dir = $$sdir($left($mircdir,3),Select your old version's dir), %d = %dir $+ mirc.ini, %d = $shortfn(%d)
  if (%dir != $mircdir) && ($isfile(%d)) _impnotify %d 1
  else sr -th Error Invalid script directory $+ $crlf $+ (mirc.ini couldn't be found, or that script's dir is in use)
}

alias _impsect {
  var %n = 1, %r
  while (%n <= $ini($1,$2,0)) {
    %r = $ini($1,$2,%n)
    writeini $shortfn($mircini) $2 %r
    inc %n
  }
  if ($ini($1,$2) == 0) sle Section $2 couldn't be found
  else sle Done importing $2 section
}

;=============================================
;get (http downloader)
/get [-h|o] <url> <path> (-h will hide dialog, o will overwrite)

alias get {
  if (-* iswm $1) var %sw = $1, %url = $2, %path = $3-
  else var %url = $1, %path = $2-
  var %path = $iif($isdir(%path),%path,download\)
  if ($chr(32) isin %path) var %path = $shortfn(%path)

  if (!%url) {
    .timer 1 0 get $$_input(Enter complete URL,e,HTTPDownloader,$iif($_isserv($cb),$ifmatch,http://))
    return
  }

  var %1 = $remove(%url,http://), %f = $gettok(%url,-1,47), %s = $gettok($gettok(%1,1,47),1,58), %p = $gettok($gettok(%1,1,47),2,58)
  if ($sock($+(get,%f))) { sr -th Error Already downloading %f | return }

  if ($isfile($+(%path,%f))) {
    if (o isin %sw) .remove %path $+ %f
    else {
      if (!$input(File already exists. $+ $crlf $+ Continue?,yw)) return
      if ($input(Overwrite? ('No' to resume),yw)) .remove %path $+ %f
    }
  }
  sockopen get $+ %f %s $iif(%p,%p,80)
  echo -qs $g Connecting...
  sockmark get $+ %f $+(http://,%1) $+ 0000000 $+ $iif($show,1,0) $+  $+ %path $+  $+ $iif(h isin %sw,1,0)
  _set misc recgets $qtok($hget(x_misc,recgets),$+(http://,%s,$iif(%p,$+(:,%p,/),/),$gettok($1,3-,47)),6,44)
}
alias -l g return (Get)
alias -l _kbps {
  if ($1) {
    var %b = $round($calc(($2 /1000) / ($ctime - $1)),2), %c = $int($calc(($3 - $2) / (%b * 1000)))
    if (%b) return %b $+ kb/s ( $+ $duration(%c) left)
  }
}
alias -l get.ccl {
  se $g Download of $gettok($1,-1,173) canceled.
  if ($dialog($1)) dialog -k $1
  .remove $iif($_smark($1,10),$ifmatch,download\) $+ $gettok($1,-1,173)
  sockclose $1
  halt
}
alias -l get.over {
  var %g = $gettok($sockname,2,173)
  if (($_smark(5) >= $_smark(3)) && ($_smark(5) > 0)) || ($_smark(3) == 0) {
    if ($_smark(9)) se $g Download of %g complete
    .signal downloader complete %g
    if (patch*.zip iswm %g) {
      _set status install.patch 1
      .timer 1 0 install.patch %g
    }
    if ($dialog($sockname)) dialog -x $sockname
  }
  elseif ($_smark(9)) se $g Download error
  sockclose $sockname
  halt
}
on 1:close:@get*:if ($sock($remove($target,@))) get.ccl $ifmatch
on 1:sockclose:get*:get.over
on 1:sockread:get*:{
  if ($sockerr) || ($sock($sockname).status != active) { if ($_smark(9)) se $g Download error. | return }
  var %sw = $sockname
  :read
  var %path = $iif($_smark(10),$ifmatch,download\), %nodialog = $_smark(11)
  if ($_smark(7) == 0) {
    var %s
    sockread %s
    if (%debug) _wecho %s
    if ($_string(HTTP/* 4*) iswm %s) || ($_string(HTTP/* 5*) iswm %s) _smark 2 $gettok(%s,2-,32)
    elseif (content-length:* iswm %s) _smark 3 $gettok(%s,2,32)
    elseif (content-type:* iswm %s) _smark 4 $iif(text/ isin %s,txt,bin)
    ;    elseif ($_string(HTTP/* 30*) iswm %s) _smark 8 1
    ;    elseif (location:* iswm %s) && ($_smark(8)) {
    ;    var %f = $gettok($_smark(1),-1,47), %u = $gettok(%s,2-,32), %h = $iif(%f isin %s,%u,$+(%u,$gettok($_smark(1),3-,47)))
    ;    .timer 1 0 .get %h
    ;    sockclose $sockname
    ;  }
    if (!%s) {
      if ($_smark(2) == 0) {
        if ($_smark(9)) se $g Socket connected, downloading file.
        if (!%nodialog) {
          if ($dialog(%sw)) dialog -x %sw
          dialog -dm %sw getd
          .timer_updget. $+ %sw -o 1 1 _updget %sw
          dialog -ti %sw $gettok(%sw,-1,173)
          did -ra %sw 2 $_smark(1)
          did -ra %sw 3 %path $+ $gettok(%sw,-1,173)
          did -ra %sw 4 $iif($_smark(3),$bytes($_smark(3),3).suf,<unknown>)
          did -ra %sw 5 0b
          if ($_smark(3) == 0) did -ra %sw 6 <unknown>
        }
        _smark 7 $sock($sockname).rcvd
        _smark 6 $ctime
      }
      else {
        if ($_smark(2)) sr -t HTTPDownloader Error $+ $crlf $+ ' $+ $_smark(2) $+ '
        else sr -t HTTPDownloader Unable to download
        sockclose %sw
      }
      return
    }
    goto read
  }
  if (!$dialog(%sw)) && (!%nodialog) get.ccl %sw
  if ($_smark(5) >= $_smark(3)) && ($_smark(5) > 0) get.over
  if ($_smark(4) == txt) {
    var %get
    sockread %get
    .write %path $+ $gettok(%sw,2,173) $iif(%get != $null,%get,$lf)
  }
  else {
    sockread &get
    bwrite %path $+ $gettok(%sw,2,173) -1 $bvar(&get,0) &get
  }
  _smark 5 $calc($sock(%sw).rcvd - $_smark(7))
  if ($sockbr == 0) return
  goto read
}
alias -l _kbps {
  if ($1 == $null) return
  var %b = $round($calc(($2 /1000) / ($ctime - $1)),2)
  if (%b) return %b $+ kb/s
}
alias -l _updget {
  if ($sock($1)) && ($dialog($1)) {
    if ($_smark($1,3)) {
      dialog -t $1 $gettok($1,2,173) ( $+ $_percentage($_smark($1,5),$_smark($1,3)) $+ )
      did -ra $1 6 $_kbps($_smark($1,6),$_smark($1,5),$_smark($1,3))
      did -a $1 1 $_smark($1,5) 0 $_smark($1,3)
    }
    did -ra $1 5 $bytes($_smark($1,5),3).suf
    .timer_updget. $+ $1 -o 1 1 _updget $1
  }
}
on 1:sockopen:get*:{
  if ($sockerr) { sr -t HTTPDownloader Error $+ $crlf $+ ' $+ $_sockerr $+ ' | return }
  var %s = $sockname, %f = $iif($_smark(10),$_smark(10),download\) $+ $gettok(%s,2,173)

  _sw %s GET / $+ $gettok($_smark(1),3-,47) HTTP/1.1
  _sw %s HEAD http:// $+ $gettok($_smark(1),2,47) HTTP/1.1
  _sw %s Accept: */*
  _sw %s User-Agent: Mozilla/4.0 (compatible; eXtreme $xtreme.ver $+ )

  if ($file(%f).size > 0) _sw %s Range: bytes= $+ $file(%f).size $+ -
  _sw %s Host: $gettok($_smark(1),2,47) $+ : $+ $sock($sockname).port
  _sw %s Connection: Keep-Alive
  _sw %s $lf
}
menu @get* {
  cancel:get.ccl $remove($active,@)
}
on 1:dialog:get*:init:0:{
  mdx.start
  multi.lang
  mdx SetControlMDX 1 progressbar > $mdx.gdll
}
on 1:dialog:get*:sclick:50:get.ccl $dname
dialog getd {
  title "getd"
  size -1 -1 166 88
  option dbu
  icon $mircexe, 8
  text "", 2, 29 9 125 7
  text "", 3, 29 17 125 7
  text "", 4, 29 25 125 7
  text "", 5, 29 36 125 7
  text "", 6, 29 44 125 7
  text "From:", 12, 7 9 20 7, right
  text "To:", 13, 7 17 20 7, right
  text "Size:", 14, 7 25 20 7, right
  text "Rcvd:", 15, 7 36 20 7, right
  text "Cps:", 16, 7 44 20 7, right
  text "", 1, 10 56 145 10
  box "", 40, 4 2 157 68
  button "Cancel", 50, 63 73 35 12, default cancel
}

;=============================================
;news

alias news {
  if ($sock(news)) sockclose news
  .timernews 1 15 sockclose news
  if ($hget(x_status,url)) {
    sockopen news $gettok($ifmatch,2,47) 80
    if ($1 != 0) _al Retrieving $iif($1,all,latest) news
    sockmark news $iif($1,1,0)
  }
}
alias -l _al if ($dialog(news)) did -ra news 10 $1- | else se $_news $1-
alias -l _news return (News)
alias -l _nclose {
  if ($_smark(3)) {
    tokenize 32 $ifmatch

    ;LASTPATCH
    if ($1 == -) {
      if ($hget(x_status,lastver) != $3) {
        _set status lastver $3
        sr -t Patch There's a new patch available, but is meant for mIRC v $+ $2 and above only
      }
    }
    else {
      _set status lastver $1
      .timer 1 0 _ask.patch $1
    }
  } 

  ;LASTNEWS
  if ($_smark(2)) {
    _set status lastnews $ifmatch
    if ($dialog(news)) _al Completed
  }

  elseif ($_smark(3) == 0) _al No news were found (since $iif($hget(x_status,lastnews),$asctime($hget(x_status,lastnews),dd/mm/yyyy),<n/a>) $+ )
  .timernews off
  sockclose $sockname
  halt
}
on 1:sockopen:news:{
  if ($sockerr) { _al Couldn't connect to site | .timernews off | return }
  else {
    if ($dialog(news)) _al Connected
    _sw GET / $+ $gettok($+($hget(x_status,url),n.txt),3-,47) HTTP/1.1
    _sw HEAD http:// $+ $gettok($hget(x_status,url),2,47) HTTP/1.1
    _sw Host: $gettok($hget(x_status,url),2,47) $+ :80
    _sw $lf
    _smark 3 0
  }
}
on 1:sockclose:news:_nclose
on 1:sockread:news:{ 
  if ($sockerr) { _al Socket error | return }
  var %nb, %patch = $iif($hget(x_status,patch),$ifmatch,1), %lver = $iif($hget(x_status,lastver),$ifmatch,1), %lnew = $iif($hget(x_status,lastnews),$ifmatch,1)
  :r
  sockread %nb
  if ($sockbr == 0) return
  if ([*]* iswm %nb) {
    var %pdate = $remove($gettok(%nb,1,32),[,]), %gn.date = $asctime(%pdate,dd/mm/yyyy HH:nn)

    ;PATCH
    if (patch* iswm $gettok(%nb,2,32)) {
      if (%pdate > %patch) && (%pdate != %lver) {
        var %s = $remove($gettok(%nb,2,32),patch)
        if (!%s) || ((%s isnum) && (%s <= $version)) && ($_smark(3) !isnum 1-) _smark 3 %pdate
        else _smark 3 - %s %pdate
      }
    }

    ;NEWS
    elseif (%pdate > %lnew) || ($_smark(1)) {
      _dialog -m news news
      did -i news 1 2 %gn.date $_tab $gettok(%nb,2-,32)
      _smark 2 %pdate
    }
  }

  ;CODE
  elseif ($gettok(%nb,1,61) == code) $eval($gettok(%nb,2-,61),2)

  if (%nb == .) _nclose | goto r
}
alias newsd _dialog -m news news
dialog news {
  title "Update / News"
  size -1 -1 300 170
  option dbu
  icon graphics\news.ico, 0
  list 1, 6 11 288 130, extsel
  text "Ready", 10, 7 162 286 7
  button "Get news", 2, 12 140 32 12
  button "All news", 3, 46 140 32 12
  button "Get patch", 4, 82 140 32 12
  button "Get sounds", 5, 116 140 32 12, hide
  box "", 21, 6 134 289 21
  button "Close", 50, 257 140 35 12, default ok
  box "", 6, -7 157 320 4
}
on 1:dialog:news:*:*:{
  if ($devent == init) {
    mdx.start
    multi.lang
    mdx SetControlMDX 1 listview rowselect flatsb showsel report nosortheader > $mdx.vdll
    did -i $dname 1 1 headerdims 100 800
    did -i $dname 1 1 headertext 0 Date $_tab Headlines
  }
  if ($devent == sclick) {
    if ($did == 2) { did -r news 1 | news }
    if ($did == 3) { did -r news 1 | news 1 }
    if ($did == 4) getpatch
    ;    if ($did == 5) get -o $xtreme.url $+ files/sounds.zip $mircdirtmp\
  }
}

alias getpatch get -o $xtreme.url $+ files/patch.zip $mircdirtmp\

alias -l _ask.patch {
  if ($input(There's a new patch available $crlf $asctime($1,dd/mm/yyyy HH:nn) $crlf $crlf Download it now?,yq,Patch)) getpatch
  else sr -t Patch You can download it later with /getpatch
}
alias install.patch {
  var %f = tmp\patch.zip
  if ($file(%f).size < 10000) return
  if (!$hget(x_status,install.patch)) {
    sr -t Error No patch file available, you must download it first with /getpatch
    return
  }
  if ($input(Do you wish to install the patch now?,yq,Patch)) {
    if ($exists(tmp\patch\)) _rmdir -d $mircdirtmp\patch\
    var %a = $dll(dlls\SZip.dll,SUnZipFile,%f > tmp\patch\)
  }
  else {
    sr -t Patch You can install it later with /install.patch
  }
}

on *:signal:SZIP: { 
  if ($1 == Z_OK) {
    if ($2 == tmp\patch.zip) {
      var %a = $finddir($mircdirtmp\patch\,*,0,__install.patch $1-)
      _reload
    }
  }
  else {
    sr -t Error Error unpacking file
  }
}

alias -l __install.patch {
  var %f1 = $1-, %f2 = $remove(%f1,tmp\patch\)
  if (!$exists(%f2)) .mkdir %f2
  var %b = $findfile(%f1,*,0,.copy -o $+(",$1-,") $+(",$remove($1-,tmp\patch\),"))
}

;stuff about the script
alias xtreme.ver return v9.0
alias xtreme.url return http://www.extreme-script.net/
alias script if (!$isid) $iif($validwin,say,ale) $_script
alias sv script
alias _script {
  return running mIRC $+ $bits $+ / $+ $version $+ [win $+ $os $+ ] - eXtreme $xtreme.ver (th/ $+ $iif($hget(x_display,theme),$gettok($gettok($ifmatch,1,46),-1,92),default) $+ ) $+ : $read(system\start.txt) $+ 
}

;/_reload (this will reload all aliases, popups and remote files (not userlist nor vars))
alias _reload {
  var %n = 1, %pl = $p.files
  while ($gettok(%pl,%n,44)) {
    var %s = system\ $+ $ifmatch, %e = $mid(%s,6,1)
    if ($isfile(%s)) .reload -p $+ %e %s
    _pwait %n 5 Reloading popups files...
    inc %n
  }
  %n = 1
  while ($alias(%n)) {
    .reload -a $+(",$ifmatch,")
    _pwait %n $alias(0) Reloading aliases files...
    inc %n
  }
  %n = 1
  while ($script(%n)) {
    var %script = $ifmatch
    if (%script != $script) .reload -rs $+(",%script,")
    _pwait %n $script(0) Reloading remote files...
    inc %n
  }
  .timer 1 0 _reload.end
  .reload -rs $+(",$script,")
}
alias -l _reload.end {
  _pwait
  if ($hget(x_status,install.patch)) || ($ini(system\upgrade.mrc,patch)) {
    _unset status install.patch
    _upg
    sr -t Patch Patch successfully installed
  }
  else sle All files were successfully reloaded
}

;upgrading stuff, mostly
alias _upg {
  if ($ini(system\upgrade.mrc,patch)) {
    var %r = $readini(system\upgrade.mrc,patch,r)
    if (%r isnum) {
      _set status lastnews %r
      _set status lastver %r
      _set status patch %r
    }
    .reload -rs system\upgrade.mrc
    if ($isalias(_upgrade)) .timer 1 0 _upgrade
    .timer 1 1 remini system\upgrade.mrc patch
  }
}



;=============================================
;sockstats

alias sockstats {
  if ($sock(*,1)) _dialog -m sstats sstats
  else sr -t SockStats No open mIRC sockets
}
dialog sstats {
  title "mIRC Sockets"
  size -1 -1 210 126
  option dbu
  icon graphics\telnet.ico, 0
  box "", 30, 5 4 199 101
  box "", 31, 81 10 115 89
  list 1, 10 15 64 86, hsbar
  text "", 11, 86 17 103 77
  button "Close sock", 41, 11 107 31 12
  button "Close all", 42, 43 107 31 12
  button "Ok", 50, 167 109 35 12, ok
}
alias -l _slrefresh {
  if (!$dialog(sstats)) { .timersstats off | return }
  if ($did(sstats,1).seltext) var %c = $ifmatch
  did -r sstats 1
  if ($sock(*,0)) {
    var %s = 1
    while ($sock(*,%s)) { did -a sstats 1 $sock(*,%s) | inc %s }
  }
  did -z sstats 1
  if ($didwm(sstats,1,%c)) { did -c sstats 1 $ifmatch | _srefresh %c }
  else did -r sstats 11
  if ($sock(*,0) == 0) { dialog -k sstats | sr -t SockStats All mIRC sockets closed. }
}
alias -l _srefresh {
  did -ra sstats 11 IP: $sock($1).ip $lf $+ Port: $sock($1).port $lf $+ Status: $sock($1).status $lf $+ Type: $upper($sock($1).type) $lf $+ Mark: $left($sock($1).mark,25) $lf $&
    $lf $+ Bytes Sent: $sock($1).sent bytes $lf $+ LastSent: $sock($1).ls secs $lf $+ Bytes Rcvd: $sock($1).rcvd bytes $lf $+ LastRcvd: $sock($1).lr secs
}
on 1:dialog:sstats:*:* {
  if ($devent == init) {
    multi.lang
    _slrefresh
    .timersstats 0 1 _slrefresh
  }
  if ($devent == sclick) {
    var %s = $did(1).seltext
    if ($did == 1) { if (!$sock(%s)) _slrefresh | _srefresh %s }
    if ($did == 41) { if ($sock(%s)) sockclose $sock(%s) | _slrefresh }
    if ($did == 42) { if (($sock(*,0)) && ($input(This will close all active mIRC sockets. $+ $crlf $+ Are you sure?,yw))) sockclose * }
  }
}

;=============================================
;startlogo

alias _startlogo {
  var %w = @startlogo
  if ($window(%w)) {
    window -c %w
    return
  }
  window -Cphk +b %w 1 1 507 170
  drawfill -sr %w 16777215 $color($color(background)) 0 0
  drawline %w 1 1 10 135 496 135
  drawtext %w 1 Arial 11 11 145 Initializing...
  drawpic %w 10 10 graphics\extreme.jpg
  window -a %w
}

;=============================================
;script count (not in use anymore)
alias _count {
  return
  var %s = count. $+ $rand(111,999)
  sockopen %s usuarios.lycos.es 80
  _smark %s 1 $1
}
on 1:sockopen:count.*:{
  if ($sockerr) return
  var %id = $_smark(1), %s = $sockname
  _sw %s GET /slack77/lc.php?f=counter $+ %id HTTP/1.1
  _sw %s Host: usuarios.lycos.es:80
  _sw %s $lf
  .timer 1 15 sockclose %s
}

;
;EOF
