;~   ~   ~   ~   ~   ~  ~   ~   ~   ~   ~   ~  
; extreme v9.0
; display/theme stuff
;
;~   ~   ~   ~   ~   ~  ~   ~   ~   ~   ~   ~  
;

; this is the theme engine, supporting 2 systems. It also supports custom theme, and selects default display if none present.
; also using mtsgen.dll by Kamek

alias -l mts.sets {
  set -u %::server $server
  set -u %::port $port
  set -u %::numeric $numeric
  set -u %::pre $_pre
  tokenize 44 $hget(x_display,basecolors)
  set -u %::c1  $+ $1
  set -u %::c2  $+ $2
  set -u %::c3  $+ $3
  set -u %::c4  $+ $4
  set -u %::timestamp $timestamp
  if (%::text) set -u %::parentext $replace($hget(x_display,parentext),<text>,%::text)
}

alias theme.text {
  var %line
  mts.sets

  ;** custom theme
  if ($hget(x_custom.theme,$1)) %line = $dll(dlls\mtsgen.dll,MTSEvalString,$replace($ifmatch,<lb>,%::lb,<rb>,%::rb,<userlevel>,%::userlevel,<country>,%::country))

  ;** MTS system
  elseif ($hget(x_mts,$1)) {
    %line = $ifmatch
    if (!script * !iswm %line) %line = $dll(dlls\mtsgen.dll,MTSEvalString,%line)
  }

  ;** normal theme system
  else {
    if (*.thm iswm $hget(x_display,theme)) %line = $theme_ [ $+ [ $remove($gettok($hget(x_display,theme),-1,92),.thm) $+ ($1) ] ]
    else %line = $_display($1)
  }

  ;** output
  if (%line != $null) {
    if (!Script * iswm %line) {
      if ($gettok(%line,2-,32) != $null) $eval($ifmatch,2)
      return
    }
    if (!%:echo) var %:echo = return
    %:echo %line %:comments
  }
}

;=====================

alias _warn return (4Warn)
alias _error return (4Error)
alias _notify return ( $+ $_c($1) $+ Notify)
alias _dns return ( $+ $_c($1) $+ DNS)

alias _pre {
  var %logo = $hget(x_display,prefix)
  if (%logo == <none>) return
  if (%logo) return $ifmatch
  return :::
}
alias logo return $_pre
alias _c {
  return $_fc($gettok($hget(x_display,basecolors),$1,44))
}

alias _fcolor return $_fc($color($1-))
alias _fc if ($len($1) == 1) return 0 $+ $1 | return  $+ $1
alias _fc2 if ($len($1) == 1) return 0 $+ $1 | return $1
alias _cf if ($1 < 10) return $right($1,1) | return $1

alias _thmset {
  var %file = $hget(x_display,theme)
  %file = $iif(thm\ isin %file,%file,$+(thm\,%file))
  if ($_readini(%file,n,$2,$1)) return $ifmatch
  return $_readini(%file,n,start,$1)
}

; this $_text identifier was made by qwerty, it should help go around the "multiple spaces" issue
alias _text {
  var %a, %b = $regsub($mid($rawmsg,$calc($pos($rawmsg,$chr(32),3) +2)),/(?<= |^)(?= |$)/g,,%a) 
  return %a
}

; alternative to $readini that retrieves control codes.it's a bit slower, though.
alias _readini {
  var %w = $+(@_readini.,$1,.,$3)
  if (!$window(%w)) {
    if (!$ini($1,$3)) return
    window -lh %w
    loadbuf -t $+ $3 %w $1
    .timer 1 2 window -c %w
  }
  var %data = $gettok($line(%w,$fline(%w,$+($4,=*))),2-,61)
  return %data
}

alias theme theme.load $1-

alias theme.load {
  if (!$1) {
    display
    return
  }

  ; MTS unload
  if ($hget(x_mts)) mts.theme.unload

  ; THM unload
  var %a = 1
  while ($alias(%a)) {
    var %file = $nopath($ifmatch)
    if (*.thm iswm %file) .unload -a $+(",$alias(%a),")
    inc %a
  }
  _--unset display scheme
  _--unset display basecolors
  _--unset display prefix
  _--unset display lb
  _--unset display rb
  _--unset display sepline1
  _--unset display sepline2
  reset.nickcolors

  ; MTS load
  if (*.mts iswm $1) {
    mts.theme.load $1-
    return
  }

  ; THM load
  var %1 = $1, %f = $addtok(%1,thm,46), %file = thm\ $+ %f
  if (!$isfile(%file)) { sr -th Error Theme file not found $+ $crlf $+ (must be in thm\ folder) | return }
  _pwait 1 10 Loading theme
  .load -a %file
  _--set display theme %f

  if ($2) hadd x_display scheme $2

  if ($dialog(display)) {
    if (!$did(display,6).state) var %notoolsw = 1
    if (!$did(display,7).state) var %notoolbuttons = 1
    if (!$did(display,8).state) var %nobackg = 1
    if (!$did(display,9).state) var %nonccols = 1
    if (!$did(display,18).state) var %nofonts = 1
    if (!$did(display,19).state) var %notimestamp = 1
  }

  _pwait 2 10 Setting colors
  set.rgbcolors $iif($_thmset(rgbcolors,$2),$ifmatch,-) 1

  if ($_thmset(colors,$2)) set.colors $ifmatch
  if ($_thmset(basecolors,$2)) hadd x_display basecolors $_fixbasecolors($ifmatch)

  _pwait 5 10 Setting logo, timestamp, etc
  if ($_thmset(prefix,$2)) hadd x_display prefix $ifmatch

  if (!%nonccols) {
    if ($_thmset(nickcolors,$2)) var %nickcolors = $ifmatch
    else def.nickcolors
    if (%nickcolors) {
      hadd -m x_display nickcolors $ifmatch
      set.nickcolors %nickcolors
    }
  }

  if (!%notimestamp) .timestamp -f $iif($_thmset(timestamp,$2),$ifmatch,(HH:nn))

  if ($read(%file,nw,*%::lb*)) {
    if ($_thmset(lb,$2)) hadd x_display lb $ifmatch
    else hadd x_display lb <
    if ($_thmset(rb,$2)) hadd x_display rb $ifmatch
    else hadd x_display rb >
  }
  if ($_thmset(sepline1,$2)) hadd x_display sepline1 $ifmatch
  if ($_thmset(sepline2,$2)) hadd x_display sepline2 $ifmatch

  if (!%nofonts) {
    _pwait 7 10 Changing fonts
    if ($_thmset(fstatus,$2)) {
      var %d = $ifmatch
      set.font $iif($gettok(%d,3,44) == b,-sb,-s) $gettok(%d,2,44) $gettok(%d,1,44)
    }
    if ($_thmset(fchannel,$2)) {
      var %d = $ifmatch
      set.font $iif($gettok(%d,3,44) == b,-cb,-c) $gettok(%d,2,44) $gettok(%d,1,44)
    }
    if ($_thmset(fquery,$2)) {
      var %d = $ifmatch
      set.font $iif($gettok(%d,3,44) == b,-qb,-q) $gettok(%d,2,44) $gettok(%d,1,44)
    }
  }

  if ($hget(x_display,load.images)) {
    _pwait 9 10 Loading images
    reset.images
    if (!%nobackg) {
      if ($_thmset(imagestatus,$2)) set.images -s $ifmatch
      if ($_thmset(imagechan,$2)) set.images -c $ifmatch
      if ($_thmset(imagequery,$2)) set.images -q $ifmatch
      if ($_thmset(imagemirc,$2)) set.images -m $ifmatch
    }
    if (!%notoolsw) {
      if ($_thmset(imagetoolbar,$2)) set.images -l $ifmatch
      if ($_thmset(imageswitchbar,$2)) set.images -h $ifmatch
    }
    if (!%notoolbuttons) {
      if ($_thmset(imagebuttons,$2)) set.images -u - $ifmatch
    }
  }

  _pwait 10 10 Finished
  if ($_thmset(onload,$2)) [ [ $ifmatch ] ]

  _pwait 

  if ($dialog(display)) did -f display 23
  _hsave x_mts
  _hsave x_display
}

alias theme.unload {
  if (!$hget(x_display,theme)) && (!$1) return
  _--unset display scheme

  _pwait 2 10 Loading default

  ; MTS unload
  if ($hget(x_mts)) mts.theme.unload

  ; THM unload
  var %oldthm = $nopath($hget(x_display,theme))
  if ($alias(%oldthm)) .unload -a %oldthm

  ; setting defaults
  _--unset display theme
  _pwait 5 10 -
  if ($1 == black) def.blackback
  else def.whiteback
  _pwait 6 10 -
  def.font
  _pwait 8 10 -
  _--unset display sepline1
  _--unset display sepline2
  _pwait 10 10 -
  set.rgbcolors - 1
  reset.images
  .timestamp -f $_c(1) $+ ( $+ $_c(3) $+ HH:nn:ss $+ $_c(1) $+ )
  hadd x_display parentext %::c1 $+ ( $+ <text> $+ %::c1 $+ )
  hadd x_display lb (
  hadd x_display rb )
  _pwait

  if ($dialog(display)) did -f display 24
  _hsave x_display
  _hsave x_mts
}

; defaults
alias colors.whiteback return 0,2,1,5,14,1,12,2,2,2,12,1,12,2,14,5,2,2,2,5,1,15,2,0,1,14,14,0
alias colors.blackback return 1,15,14,8,15,0,15,11,4,10,6,0,11,15,0,11,10,10,0,13,14,1,0,1,0,15,15,1
alias def.whiteback {
  _--set display basecolors 02,04,01,12
  set.colors $colors.whiteback
  hadd -m x_display prefix $_c(1) $+ : $+ $_c(3) $+ : $+ $_c(1) $+ :
  def.nickcolors
}
alias def.blackback {
  _--set display basecolors 10,04,15,11
  set.colors $colors.blackback
  hadd -m x_display prefix $_c(1) $+ : $+ $_c(3) $+ : $+ $_c(1) $+ :
  def.nickcolors
}
alias def.font {
  set.font -s 11 Tahoma
  set.font -c 11 Tahoma
  set.font -q 12 Tahoma
}
alias reset.nickcolors {
  var %n = $cnick(0)
  while (%n) {
    if (~ isin $cnick(%n).modes) .cnick -r %n
    dec %n
  }
}
alias set.nickcolors {
  reset.nickcolors
  if ($hget(x_display,color.nicks.messages)) var %m = 0
  else var %m = 2
  if ($gettok($1,4,44) != 20) .cnick -yanovpm $+ %m * $ifmatch ~
  if ($gettok($1,5,44) != 20) .cnick -ianm $+ %m * $ifmatch ~
  if ($gettok($1,6,44) != 20) .cnick -m $+ %m * $ifmatch @.~
  if ($gettok($1,7,44) != 20) .cnick -m $+ %m * $ifmatch +%~
  if ($gettok($1,8,44) != 20) .cnick -nm $+ %m * $ifmatch ~
}
alias def.nickcolors {
  if ($color(background) == 1) var %nickcolors = 7,4,14,11,15,20,20,20
  else var %nickcolors = 5,4,14,12,15,02,20,20
  _set display nickcolors %nickcolors
  set.nickcolors %nickcolors
}

alias set.font {
  if (-* !iswm $1) return
  if (s isin $1) {
    font $iif(b isin $1,-sb,-s) $2-
  }
  var %c = $chan(0), %q = $query(0), %ch = $chat(0), %ft = $3- $+ $chr(44) $+ $calc($iif(b isin $1,700,400) + $2), %f = $+(",$mircini,") fonts, %sw = $iif(b isin $1,-db,-d)

  if (s isin $1) {
    font -s $2-
    font -g $2-
  }
  if (c isin $1) {
    if (%c) {
      while (%c) { font %sw $chan(%c) $2- | dec %c }
    }
    else writeini %f fchannel %ft
  }
  if (q isin $1) {
    if (%q) {
      while (%q) { font %sw $query(%q) $2- | dec %q }
    }
    else writeini %f fquery %ft
    if (%ch) {
      while (%ch) { font %sw $chat(%ch) $2- | dec %ch }
    }
    else writeini %f fchat %ft
    if ($window(Message Window)) font %sw Message Window $2-
    else writeini %f fmessage %ft
  }
  saveini
}
alias set.colors {
  var %t = $retcols, %n = 1, %bg = $iif($gettok($1,1,44) isnum,$ifmatch,0)
  while (%n <= $numtok(%t,46)) {
    var %c = $gettok($1,%n,44)
    if (%c isnum) {
      color $gettok(%t,%n,46) %c
    }
    else color $gettok(%t,%n,46) $gettok($iif(%bg,$colors.blackback,$colors.whiteback),%n,44)
    inc %n
  }
}
alias set.rgbcolors {
  var %n = 0
  while (%n <= 15) {
    if ($gettok($1,$calc(%n +1),44) isnum) {
      var %c = $ifmatch
      if ($color(%n) != %c) color %n %c
    }
    else {
      var %c = $defaultrgbcols($calc(%n +1))
      if ($color(%n) != %c) color -r %n
    }
    if ($2 == 1) _createmcolbox %n %c
    inc %n
  }
}

alias _createmcolbox {
  window -ph +l @_cmb 0 0 24 40
  drawrect -rf @_cmb $2 1 0 0 30 30 
  drawsave @_cmb graphics\ $+ $_cf($1) $+ .bmp
  window -c @_cmb
}

alias reset.images {
  if ($color(back) == 1) background -mt graphics\bkgd_b1.jpg
  else background -mt graphics\bkgd_w1.jpg
  background -hx
  background -lx
  background -ux
  ;  background -u graphics\winxp_toolbar.bmp
  background -sx
  var %i = 1 | while ($chan(%i)) { background -x $ifmatch | inc %i }
  var %i = 1 | while ($query(%i)) { background -x $ifmatch | inc %i }
  var %i = 1 | while ($chat(%i)) { background -x $ifmatch | inc %i }
  if ($window(Message Window)) background -x $ifmatch
  remini mirc.ini background wchannel
  remini mirc.ini background wquery
  remini mirc.ini background wchat
  remini mirc.ini background wmessages
}

alias set.images {
  var %switch = $1, %style = $remove($left($2,1),-), %file = $3
  if (!$isfile(%file)) var %file = $mts.theme.dir $+ $3
  if (!$isfile(%file)) var %file = thm\ $+ $3
  if (!$isfile(%file)) return
  var %style2 = - $+ $remove(%switch,c,q) $+ %style $+ e
  if (c isin $1) || (q isin $1) {
    var %n = $calc($findtok(c.f.n.r.t.p,%style,46) -1)
    if (c isin $1) {
      var %i = 1
      while ($chan(%i)) { background - $+ %style $ifmatch %file | remini mirc.ini background $chan(%i) | inc %i }
      writeini mirc.ini background wchannel %file $+ , $+ %n
    }
    if (q isin $1) {
      var %i = 1 | while ($query(%i)) { background - $+ %style $ifmatch %file | remini mirc.ini background $query(%i) | inc %i }
      writeini mirc.ini background wquery %file $+ , $+ %n
      var %i = 1 | while ($chat(%i)) { background - $+ %style $ifmatch %file | remini mirc.ini background $chat(%i) | inc %i }
      writeini mirc.ini background wchat %file $+ , $+ %n
      if ($window(Message Window)) background - $+ %style $ifmatch %file
      else writeini mirc.ini background wmessages %file $+ , $+ %n
    }
  }
  else background %style2 %file
}
;

alias _settimestamp .timestamp -f $1-

alias retcols return background.action.ctcp.highlight.info.info2.invite.join.kick.mode.nick.normal.notice.notify.other.own.part.quit.topic.wallops.whois.editbox.editbox text.listbox.listbox text.gray.title.inactive
alias getactualcols {
  var %t = $retcols, %n = 1, %l
  while ($gettok(%t,%n,46)) {
    %l = %l $+ , $+ $color($ifmatch)
    inc %n
  }
  return $right(%l,-1)
}
alias getrgbcols {
  var %n = 0
  while (%n <= 15) {
    var %l = %l $+ , $+ $color(%n)
    inc %n
  }
  return $right(%l,-1)
}
alias defaultrgbcols return $gettok($defaultrgbcolslist,$1,44)
alias defaultrgbcolslist return 16777215,0,8323072,37632,255,127,10223772,32764,65535,64512,9671424,16776960,16515072,16711935,8355711,13816530
alias defaultcols return 0,0,1,0,1,6,4,5,2,3,3,3,3,3,3,1,5,7,2,1,3,2,3,5,1,1,0
alias rgbcols.fix {
  var %l = $1, %i = 1
  while (%i <= $numtok($1,44)) {
    if ($gettok($1,%i,44) !isnum) %l = $puttok(%l,$defaultrgbcols(%i),%i,44)
    inc %i
  }
  return %l
}

alias sepline1 {
  if ($hget(x_display,sepline1)) return $ifmatch
  var %c = -
  return $+($_c(1),$_c(4),$str(%c,6),$_c(1),$str(%c,12),$_c(4),$str(%c,5),$_c(1),$str(%c,4),$_c(4),$str(%c,3),$_c(1),$str(%c,10),$_c(4),$str(%c,10),$_c(1),$str(%c,12),$_c(4),$str(%c,3),$_c(1),$str(%c,2),$_c(4),%c)
}
alias sepline2 {
  if ($hget(x_display,sepline2)) return $ifmatch
  var %c = -
  return $+($_c(1),$str(%c,3),$_c(4),$str(%c,4),$_c(1),$str(%c,4),$_c(4),$str(%c,2),$_c(1),$str(%c,13),$_c(4),$str(%c,4),$_c(1),%c,$_c(4),%c,$_c(1),$str(%c,5),$_c(4),$str(%c,3),$_c(1),$str(%c,3),$_c(4),%c)
}

; MTS

alias mtsversion return 1.3
alias theme.setting {
  if ($hget(x_mts,$1)) return $ifmatch
  if ($2) return $_display($1)
}
alias -l mts.theme.load {
  var %file = $1
  if (!$isfile(%file)) return
  window -hl @mts
  loadbuf -tmts @mts %file
  _hfree x_mts
  hmake x_mts 7

  _pwait 1 10 Processing lines...
  var %n = 1
  while ($line(@mts,%n)) {
    var %line = $ifmatch, %1 = $gettok(%line,1,32), %2 = $gettok(%line,2-,32)
    ;    if (;* !iswm %line) && (%2 != $null) hadd x_mts %1 $'repcolor(%2)
    if (;* !iswm %line) && (%2 != $null) hadd x_mts %1 %2
    inc %n
  }
  window -c @mts

  if ($theme.setting(mtsversion) > $mtsversion) {
    _hfree mts
    sr -th Error MTS theme version is not supported by this theme engine
    return
  }

  _--unset display basecolors
  _--unset display prefix
  _--unset display align
  _--unset display scheme
  reset.nickcolors

  if ($2) {
    _pwait 4 10 Loading scheme...
    var %w = @mts.sch
    window -hl %w
    loadbuf -t $+ $2 %w %file
    var %n = 1
    while ($line(%w,%n)) {
      var %line = $ifmatch, %1 = $gettok(%line,1,32), %2 = $gettok(%line,2-,32)
      if (;* !iswm %line) {
        if (%2 == $null) %2 = <null>
        if (%1 != $null) hadd x_mts %1 $'repcolor(%2)
      }
      inc %n
    }
    window -c %w
    hadd x_display scheme $2
  }

  hadd -m x_mts mts.theme.dir $remove($nofile(%file),$shortfn($mircdir),$mircdir)

  if ($dialog(display)) {
    if (!$did(display,1006).state) var %notoolsw = 1
    if (!$did(display,1007).state) var %notoolbuttons = 1
    if (!$did(display,1008).state) var %nobackg = 1
    if (!$did(display,1009).state) var %nonccols = 1
    if (!$did(display,1018).state) var %nofonts = 1
    if (!$did(display,1019).state) var %notimestamp = 1
  }

  _pwait 6 10 Loading settings...

  var %bcolors = $_fixbasecolors($theme.setting(basecolors))
  hadd -m x_display basecolors %bcolors
  set -u %::c1 $_fc($gettok(%bcolors,1,44))
  set -u %::c2 $_fc($gettok(%bcolors,2,44))
  set -u %::c3 $_fc($gettok(%bcolors,3,44))
  set -u %::c4 $_fc($gettok(%bcolors,4,44))

  var %colors = $theme.setting(colors), %rgbcolors = $rgbcolors.mts2thm($iif($theme.setting(rgbcolors),$ifmatch,-))

  if ($theme.setting(prefix)) {
    var %prefix = $replace($ifmatch,<c1>,%::c1,<c2>,%::c2,<c3>,%::c3,<c4>,%::c4)
    hadd -m x_display prefix %prefix
    set -u %::pre %prefix
  }
  if ($theme.setting(parentext)) hadd -m x_display parentext $replace($ifmatch,<c1>,%::c1,<c2>,%::c2,<c3>,%::c3,<c4>,%::c4)
  else hadd -m x_display parentext %::c1 $+ ( $+ <text> $+ %::c1 $+ )

  if (!%notimestamp) {
    if ($theme.setting(timestampformat)) var %ts = $ifmatch
    else {
      if ($theme.setting(timestamp) !isin on.off) var %ts = $ifmatch
      else var %ts = (HH:nn)
    }
    .timestamp -f $replace(%ts,<c1>,%::c1,<c2>,%::c2,<c3>,%::c3,<c4>,%::c4)
  }
  if (!%nonccols) {
    reset.nickcolors
    var %nickcolors = 20,20,20,20,20,20,20,20
    if ($hget(x_display,color.nicks.messages)) var %m = m0
    else var %m = m2
    if ($theme.setting(clineme) isnum) %nickcolors = $puttok(%nickcolors,$calc($ifmatch % 16),1,44)
    if ($theme.setting(clineircop) isnum) %nickcolors = $puttok(%nickcolors,$calc($ifmatch % 16),2,44)
    if ($theme.setting(clinefriend) isnum) %nickcolors = $puttok(%nickcolors,$calc($ifmatch % 16),4,44)
    if ($theme.setting(clineenemy) isnum) %nickcolors = $puttok(%nickcolors,$calc($ifmatch % 16),5,44)
    if ($theme.setting(clineop) isnum) %nickcolors = $puttok(%nickcolors,$calc($ifmatch % 16),6,44)
    if ($theme.setting(clinevoice) isnum) %nickcolors = $puttok(%nickcolors,$calc($ifmatch % 16),7,44)
    if ($theme.setting(clineregular) isnum) %nickcolors = $puttok(%nickcolors,$calc($ifmatch % 16),8,44)
    hadd -m x_display nickcolors %nickcolors
    set.nickcolors %nickcolors
  }

  ;loading script file
  if ($theme.setting(script)) {
    var %sf = $ifmatch, %script = $mircdir $+ $mts.theme.dir $+ %sf
    if (!$script(%script)) .load -rs " $+ %script $+ "
  }

  ;on load event
  if ($theme.setting(load)) {
    var %load = $ifmatch
    set -u %:echo echo -s
    if ($gettok(%load,1,32) == !script) $eval($gettok(%load,2-,32),2)
    else se $replace(%load,<c1>,%::c1,<c2>,%::c2,<c3>,%::c3,<c4>,%::c4,<pre>,%prefix)
  }

  _pwait 7 10 Setting colors...

  set.colors %colors
  set.rgbcolors %rgbcolors 1

  if (!%nofonts) { 
    _pwait 8 10 Changing fonts

    if ($theme.setting(fontdefault)) {
      var %f = $remove($ifmatch,")
      set.font $iif($gettok(%f,3,44) == b,-sb,-s) $gettok(%f,2,44) $gettok(%f,1,44)
    }
    if ($theme.setting(fontchan)) {
      var %f = $remove($ifmatch,")
      set.font $iif($gettok(%f,3,44) == b,-cb,-c) $gettok(%f,2,44) $gettok(%f,1,44)
    }
    if ($theme.setting(fontquery)) {
      var %f = $remove($ifmatch,")
      set.font $iif($gettok(%f,3,44) == b,-qb,-q) $gettok(%f,2,44) $gettok(%f,1,44)
    }
  }

  if ($hget(x_display,load.images)) {
    _pwait 9 10 Loading images
    reset.images
    if (!%nobackg) { 
      if ($theme.setting(imagestatus)) set.images -s $ifmatch
      if ($theme.setting(imagechan)) set.images -c $ifmatch
      if ($theme.setting(imagequery)) set.images -q $ifmatch
      if ($theme.setting(imagemirc)) set.images -m $ifmatch
    }
    if (!%notoolsw) {
      if ($theme.setting(imagetoolbar)) set.images -l $ifmatch
      if ($theme.setting(imageswitchbar)) set.images -h $ifmatch
    }
    if (!%notoolbuttons) {
      if ($theme.setting(imagebuttons)) set.images -u - $ifmatch
    }
  }


  ;-------------

  _pwait 10 10 Finished

  hadd -m x_display theme $nopath(%file)
  _hsave x_mts
  _hsave x_display
  _pwait
}

alias -l mts.theme.unload {
  var %colors = $theme.setting(basecolors), %c1 = $_fc($gettok(%colors,1,44)), %c2 = $_fc($gettok(%colors,2,44)), %c3 = $_fc($gettok(%colors,3,44)), %c4 = $_fc($gettok(%colors,4,44))
  if ($theme.setting(script)) {
    var %sf = $ifmatch, %script = $mircdir $+ $mts.theme.dir $+ $nopath(%sf)
    if ($script(%script)) .unload -rs " $+ %script $+ "
  }
  if ($theme.setting(prefix)) var %prefix = $replace($ifmatch,<c1>,%c1,<c2>,%c2,<c3>,%c3,<c4>,%c4)
  if ($theme.setting(unload)) {
    var %load = $ifmatch
    set -u %:echo echo -s
    set -u %::c1 %c1
    set -u %::c2 %c2
    set -u %::c3 %c3
    set -u %::c4 %c4
    if ($gettok(%load,1,32) == !script) $eval($gettok(%load,2-,32),2)
    else se $replace(%load,<c1>,%c1,<c2>,%c2,<c3>,%c3,<c4>,%c4,<pre>,%prefix)
  }
  _hfree x_mts
  _hsave x_mts
}

alias mts.theme.dir return $theme.setting(mts.theme.dir)

alias rgbcolors.mts2thm {
  if (!$1) return
  var %w = @ $+ $_rand6, %n = 1, %_rgb, %rgb, %list
  window -lh %w
  loadbuf %w system\mts_rgbcols.tbl
  while (%n <= 16) {
    %_rgb = $gettok($1-,%n,32)
    if ($remove(%_rgb,$chr(44)) !isnum) %_rgb = $gettok($line(%w,$fline(%w,%_rgb *,1)),2,32)
    %rgb = $rgb( [ %_rgb ] )
    if (%rgb isnum) %list = %list $+ , $+ %rgb
    else %list = %list $+ ,-
    inc %n
  }
  window -c %w
  return $right(%list,-1)
}
alias rgbcolors.thm2mts {
  if (!$1) return
  var %w = @ $+ $_rand6, %n = 1, %_rgb, %rgb, %list
  window -lh %w
  loadbuf %w system\mts_rgbcols.tbl
  while (%n <= 16) {
    var %_rgb = $rgb($gettok($1-,%n,44)), %cname = $gettok($line(%w,$fline(%w,* %_rgb,1)),1,32)
    if (%cname) %rgb = %cname
    else %rgb = %_rgb
    %list = %list %rgb
    inc %n
  }
  window -c %w
  return %list
}

; $'repcolor(string, n1, n2[, n3, n4[, ..., nN]]) by cold
; - replaces colors which code is n1 to n2, then n3 to n4 and successively, but not if the code that's ought to be replaced has a background color
alias 'repcolor {
  ;  var %i = 0, %s = $1, %c = $2-, %p = $0 - 1
  var %i = 0, %s = $1, %c = 1 01 2 02 3 03 4 04 5 05 6 06 7 07 8 08 9 09, %p = 18
  while (%i < %p) {
    inc %i 2
    tokenize 32 $gettok(%c, $+($calc(%i -1),-,%i), 32)
    if ($0 < 2) { break }
    if ($1 !isnum 0-99) || ($2 !isnum 0-99) { return }
    var %x, %y = $regsub(%s, /( $+ $1)( $+ $iif(? iswm $1,[^0-9,[^) $+ $chr(44) $+ ])/g, $+(,$2,\2), %x)
    if (? iswm $1) { %y = $regsub(%x, /( $+ $base($1,10,10,2) $+ )([^0-9 $+ $chr(44) $+ ])/g, $+(, $base($2,10,10,2), \2), %x) }
    %s = %x
  }
  return %x
}
alias _fixbasecolors {
  var %i = 1
  while (%i <= $numtok($1,44)) { var %col = $_fc2($gettok($1,%i,44)), %list = %list %col | inc %i }
  return $replace(%list,$chr(32),$chr(44))
}
;====================
;nickcolors

alias _ncread {
  if (!$1) return $hget(x_display,nickcolors.stat)
  var %1 = $iif($1 isnum,$1,$findtok(you.ircop.away.friend.enemy.op.voice.regular,$1,1,46)), %res = $gettok($hget(x_display,nickcolors),%1,44)
  if (%res isnum 0-15) return %res
}
alias nickcol {
  if ($2 ischan) && ($1 ison $2) {
    if ($_ncread) && ($3 isnum) cline $3 $2 $1
    else cline -r $2 $1
  }
}
alias _getcol {
  var %cols = $hget(x_display,nickcolors)
  if ($gettok($2,2,32) isnum) return $ifmatch
  elseif ($1 == $me) && ($_ncread(you)) return $ifmatch
  elseif ($address($1,2) iswm $__i(myaddress)) && ($hget(x_display,color.myclones)) && ($_ncread(you)) return $ifmatch
  elseif ($istok($2,20,44)) || ($ial($1).mark == ircop) && ($_ncread(ircop)) return $ifmatch
  elseif ((F isincs $2) || ($1 isnotify)) && ($_ncread(friend)) return $ifmatch
  elseif (E isincs $2) && ($_ncread(enemy)) return $ifmatch
  elseif ($ial($1).mark == away) && ($_ncread(away)) return $ifmatch
  ;  elseif ($1 isop $3) || ($1 isowner $3) return $_ncread(op)
  ;  elseif (($1 isvoice $3) || ($1 ishop $3)) && ($_ncread(voice)) return $ifmatch
  ;  else return $_ncread(regular)
}

alias colornicks.all {
  var %c = 1
  while ($chan(%c)) {
    .colornicks $ifmatch upd
    inc %c
  }
}
;/colornicks <chan> (this will rely on nicks, or, if the ial is complete, on addresses as well)
alias colornicks {
  if ($1 !ischan) return
  sline -r $1
  var %i = 1, %total = $nick($1,0)
  if ($2) _pwait 0 1 Updating nickcolors for $1 $+ ...
  while (%i <= %total) {
    var %nick = $nick($1,%i), %add = $iif($address(%nick,5),$ifmatch,$+(%nick,!*@*)), %lev = $_getflagshd(%add,$1), %hand = $gettok(%lev,1,32), %flags = $iif($gettok(%lev,2,32),$ifmatch,+)
    if (%hand) {
      var %color = $_aul(UserEntryGetW,$_network %hand XTRA Nickcolor)
      if (%color isnum 0-15) %flags = %flags %color
    }
    if (B isincs %flags) && ($_ischanrec(%hand,$1)) set $_i(bots.on.,$1) $addtok($__i(bots.on.,$1),%nick,44)
    nickcol %nick $1 $_getcol(%nick,%flags,$1)
    if ($2) _pwait %i %total Updating nickcolors ( $+ %i $+ / $+ %total $+ )
    inc %i
  }
  if ($2) {
    _pwait
    echo -q $1 $_pre Nickcolors updated for $1
  }
}

;/colornick.ial <chan> <nick> <fulladdress> <flags> (this works from raw 352)
alias colornick.ial {
  var %lev = $_getflagshd($3,$1), %hand = $gettok(%lev,1,32), %flags = $iif($gettok(%lev,2,32),$ifmatch,+)
  if (%hand) {
    var %color = $_aul(UserEntryGetW,$_network %hand XTRA Nickcolor)
    if (%color isnum 0-15) %flags = %flags %color
  }
  if ($2 !ison $1) halt
  if (* isin $4) {
    if ($ulist(*,20,1) !iswm $3) .auser -a 20 $mask($3,1) ircop
    .ialmark $2 ircop
  }
  elseif (H !isin $4) {
    .ialmark $2 away
  }
  nickcol $2 $1 $_getcol($2,%flags,$1)
}

alias _cline {
  if ($1 == -d) var %c = $_getcol($2,-,-)
  else var %c = $1
  var %t.chan = $comchan($2,0)
  while (%t.chan) {
    cline %c $comchan($2,%t.chan) $2
    dec %t.chan
  }
}

alias _ns {
  var %n = $remove($1,@,+,.,%), %c = $2
  if (%c !ischan) return %n
  var %x = $nick(%c,$1).pnick, %col = $nick(%c,$1).color
  if (%x == $null) %x = $1
  if ($showmodeprefix) var %n = $left($remove(%x,%n),1) $+ %n
  if ($hget(x_display,color.nicks.messages)) && (%col != $color(listbox text)) var %n = $+(,%col,%n,)
  return %n
}
alias _align {
  if ($hget(x_display,align.nick)) || ($2) {
    var %1 = $strip($1), %al = $iif($2,$2,$hget(x_display,align.nick)), %l = $gettok(%al,1,59), %t = $gettok(%al,2,59), %f = $chr($gettok(%al,3,59)), %a = $len(%1)
    if (%t == 2) {
      if ($left(%1,1) !isin $prefix) var %nick = $+(%f,$1), %a = %a + 1
      else var %nick = $1
      return %nick $+ $str(%f,$calc(%l - %a))
    }
    if (%t == 3) {
      var %c = $int($calc((%l - %a)/2))
      return $str(%f,%c) $+ $1 $+ $str(%f,$calc(%l - %a - %c))
    }
    if (%t == 4) return $str(%f,$calc(%l - %a)) $+ $1

    return $1 $+ $str(%f,$calc(%l - %a))
  }
  return $1
}

alias _fade.nick {
  if ( isin $1) return $1
  var %c1 =  $+ $iif($2 isnum,$_fc($2),15), %c2 =  $+ $iif($3 isnum,$_fc($3),00)
  var %1 = $remove($1,), %n
  if ($len(%1) isnum 1-2) %n = %c2 $+ %1 $+ 
  else %n = %c1 $+ $left(%1,1) $+ %c2 $+ $mid(%1,2,$calc($len(%1) - 2)) $+ %c1 $+ $right(%1,1) $+ 
  return $replace($1,%1,%n)
}

;=======================
; echoes

alias ale {
  if ($1 != $null) {
    echo $color(info2) $iif(@* iswm $active,-si2,-ai2) $_pre $1- $iif($activecid != $cid,( $+ $__i(network) $+ ))
    _lastecho $1-
  }
}
alias ae {
  if ($1 != $null) {
    echo $color(info2) $iif($activecid != $cid || @* iswm $active,-si2,-ai2) $1-
    _lastecho $1-
  }
}
alias aae {
  if ($1 != $null) {
    echo $color(info2) $iif(@* iswm $active,-si2,-ai2) $1- $iif($activecid != $cid,( $+ $__i(network) $+ ))
    _lastecho $1-
  }
}

alias sle {
  if ($1 != $null) echo $color(info2) -si2 $_pre $1-
}
alias se {
  if ($1 != $null) {
    echo $color(info2) -si2 $1-
  }
}
alias sae {
  if ($1 != $null) {
    echo $color(info2) -si2 $1-
    if ($validwin) echo $color(info2) -ai2 $1- $iif($activecid != $cid,( $+ $__i(network) $+ ))
    _lastecho $1-
  }
}
alias slae {
  if ($1 != $null) {
    echo $color(info2) -si2 $_pre $1-
    if ($validwin) echo $color(info2) -ai2 $_pre $1- $iif($activecid != $cid,( $+ $__i(network) $+ ))
    _lastecho $1-
  }
}

alias _echos {
  var %cache = $+(x_tmp-cid,$cid,-cache)
  if ($hget(%cache,$+(echos.,$1,.,$2))) return $ifmatch
  var %s = $readini(mirc.ini,events,$2)
  if ($gettok(%s,$1,44) != $null) var %res = $calc($ifmatch -1)
  else var %res = $gettok($readini(mirc.ini,events,default),$1,44)
  hadd -mu5 %cache $+(echos.,$1,.,$2) %res
  return %res
}
alias e.ev {
  var %j = $_echos($1,#)
  if (%j == 1) return echo $2 -st
  if (%j == 2) return return
  return echo $2 -t #
}

;/_custom.echo <names/wallops/snotices/who/whoislist/whois/ctcp/bans/scans> (default,status,active,channel,window)
alias _custom.echo {
  if (!$1) return

  var %col, %text = $iif($2- != $null,$2,-)
  if ($1 == snotices) %col = notice
  elseif ($1 isin wallops.names.whois.ctcp) %col = $1
  else var %col = text

  var %opt = $hget(x_wins,$gettok($1,1,40)), %cl = $color(%col)
  if (%opt == window) _custom.echo.win %cl $1-
  elseif (%opt == default) {
    var %a
    if ($1 == whois) && ($whoisonact) %a = 1
    if ($1 == ctcp) && ($ctcponact) %a = 1
    echo %cl $iif((%a && @* !iswm $active),-a,-sm) $2-
  }
  elseif (%opt == channel) echo %cl %::chan $2-
  elseif (%opt == active) echo %cl $iif(@* !iswm $active,-a,-s) $2-
  else echo %cl -sm $2-
}
alias _editbox if ($numtok($editbox($2),32) < 3) editbox $1-

;/_custom.echo.win <color> <creates window> (default,status,active,channel,window)
alias _custom.echo.win {

  var %w = $+(@,$2,,$_@network), %1 = $+(@,$2), %col = $1

  ce.window $2

  if (@service isin %w) {
    var %nick = $lower($right($left($remove($2,service),-1),-1))
    if ($__i(nets-log.msgserv)) _editbox -p %w /msg %nick
    else _editbox -p %w / $+ %nick
  }
  elseif (notice* iswm $2) {
    _editbox -p %w /notice $iif($chan,$target,$nick)
  }
  else _editbox -p %w / $+ $lower($2))

  var %i = 1
  while ($gettok($3-,%i,182)) {
    var %line = $ifmatch
    aline -p %col %w %line
    if ($hget(x_wins,$+(save.tome.,%1))) write $+(logs\,$deltok(%w,-1,160),.txt) %line
    inc %i
  }
  window -g1 %w
}

alias ce.window {
  var %w = $+(@,$1,,$_@network), %1 = $+(@,$1), %f = $+(logs\,$deltok(%w,-1,160),.txt)
  if (!$window(%w)) {
    window -eka $+ $iif($2 == $null,n) +e %w $_gcoord($1,150 100 550 250) @_tome
    if (($2) || ($hget(x_wins,$+(save.tome.load.,%1)))) && ($isfile(%f)) {
      loadbuf %w %f
      linesep %w
    }
  }
}
on 1:INPUT:@notices*:{
  _editbox -p $target $1-2
  return
}

;=====================
;whoislist

alias whoislist {
  if ($__i(whoislstart)) {
    sr -th Error Already listing users in another channel, please wait
    return
  }
  if ($1 ischan) var %c = $1
  else var %l = $1
  if (%l) {
    var %c = $gettok(%l,1-3,44)
    if ($numtok(%l,44) > 3) %c = %c $+ ,...
    %c = ( $+ %c $+ )
  }
  else var %c = $iif($1 ischan,$1,#)

  window -c $+(@Whoislist,%c,,$_@network)

  var %win = $+(@_whoislist,%c,,$_@network), %max = $iif($2 isnum,$2,$__i(nets-max.events)), %n = 1
  window -c %win
  window -hl %win
  if (%l) {
    while ($gettok(%l,%n,44)) {
      aline %win $ifmatch
      inc %n
    }
  }
  else {
    while ($nick(%c,%n,a)) {
      aline %win $ifmatch
      inc %n
    }
  }

  if ((($line(%win,0) > 30) && (%max == 1)) || ($line(%win,0) > 100)) && (!$input(This will take some time and $crlf it may lag you a lot $crlf $crlf Continue anyway?,yw)) {
    window -c %win
    return
  }
  echo -qa $_pre Generating WHOIS list $iif(%l,for %l,for %c)

  set -u180 $_i(whoislchan) %c
  set -u180 $_i(whoislstart) $ticks

  var %i = 1, %n
  while (%i <= %max) {
    var %nick = $line(%win,%i)
    if (%c !ischan) || (%nick ison %c) %n = $addtok(%n,%nick,44)
    inc %i
    if (%i > $line(%win,0)) break
  }
  .raw WHOIS %n $iif(%max == 1,%n)
  set $_i(whoislist) %n
  set $_i(whoisln) %i
  set $_i(whoislmax) %max
  set $_i(whoislparams) $1
  .timerwhoislist. $+ %c 1 180 _stopwhoisl
}

alias _stopwhoisl {
  var %c = $__i(whoislchan), %w = $+(@_whoislist,%c,,$_@network)
  window -c %w
  set -u10 $_i(whoislstop.,%c) 1
  .timer 1 10 unset $_i(whoisl*)
  .timerwhoislist. $+ %c off
}
alias _addwhoisl {
  var %c = $__i(whoislchan), %w = $+(@Whoislist,%c,,$_@network), %w2 = $+(@_whoislist,%c,,$_@network), %ln = $__i(whoisln), %max = $__i(whoislmax)
  if (!%c) || (!$window(%w2)) {
    unset $_i(whoisl*)
    return
  }
  if ($__i(whoislstop.,%c)) return

  if (!$window(%w)) {
    window $iif(%idlekick,-klh,-knl) -t13,40,60,75 +e %w $_gcoord(who,-1 -1 770 400) @who $_@font
    aline %w $chr(9)
    aline %w $chr(9)
    aline %w $_c(1) $+ Nick $chr(9) $_c(1) $+ Address $chr(9) $_c(1) $+ Server $chr(9) $_c(1) $+ Idle time $chr(9) $_c(1) $+ Channels
    aline %w $chr(9)
  }

  if ($1) {
    titlebar %w ( $+ $calc(%ln -1) of $line(%w2,0) users)
    aline %w $replace($1-,,$chr(9))
  }

  if ($numeric != 318) return

  if (%ln <= $line(%w2,0)) {
    var %i = %ln, %maxt = $calc(%ln + %max), %n

    while (%i < %maxt) {
      var %nick = $line(%w2,%i)
      if (%c !ischan) || (%nick ison %c) %n = $addtok(%n,%nick,44)
      else {
        dline %w2 %i
        dec %i
      }
      inc %i
      if (%i > $line(%w2,0)) break
    }
    .timer -m 1 500 .raw WHOIS %n $iif(%max == 1,%n)
    set $_i(whoislist) %n
    set $_i(whoisln) %i
    .timerwhoislist. $+ %c 1 180 _stopwhoisl
  }
  else {

    echo $iif(@* iswm $active,-s,-a) $_pre List complete ( $+ $round($calc(($ticks - $__i(whoislstart)) /1000),2) $+ secs)
    titlebar %w (Complete: $line(%w2,0) users)
    window -br %w
    window -c %w2
    .timerwhoislist. $+ %c off
    unset $_i(whoisl*)
  }
}
on 1:close:@Whoislist*:_stopwhoisl


;==============

on *!:join:#:_add.wholist # $nick
on *!:part:#:_rem.wholist # $nick
on *:kick:#:_rem.wholist # $nick
on *!:quit:{
  var %n = 1
  while ($comchan($nick,%n)) {
    var %c = $ifmatch
    _rem.wholist %c $nick
    inc %n
  }
}
alias _rem.wholist {
  if (!$hget(x_display,aupdate.wholist)) || (!$window($+(@Who,$1))) return
  var %w = $+(@Who,$1), %line = $fline(%w,$2 *,1), %n = $remove($gettok($window(%w).title,-1,32),$chr(41))
  if (%line) {
    dline %w %line
    titlebar %w $puttok($window(%w).title,$+($calc(%n -1),$chr(41)),-1,32)
  }
}
alias _add.wholist {
  if (!$hget(x_display,aupdate.wholist)) || (!$window($+(@Who,$1))) return
  set $_i(who.upd.,$2) $1
  .raw WHO $2
}

;================

alias _echo.whois {
  if ($__i(whois.on.query.,$1)) && ($query($1)) {
    var %query = $1
    linesep $1
  }
  elseif ($__i(whois.on.join.,$1)) {
    var %chan = $ifmatch
    if (%chan ischan) linesep %chan
  }
  var %h = $+(x_tmp-cid,$cid,-whois,.,$1)
  if ($2- == start) hmake %h 2
  elseif ($2- == end) {
    var %n = 1
    while ($hget(%h,%n)) {
      var %l = $ifmatch
      if ($query(%query)) echo $color(whois) $1 %l
      elseif (%chan ischan) echo $color(whois) %chan %l
      else _custom.echo Whois %l
      inc %n
    }
    _hfree %h
    unset $_i(whois.on.query.,$1)
    if (%query) linesep $1
  }
  else hadd -m %h $calc($hget(%h,0).item +1) $2-
}

;EOF
