;~   ~   ~   ~   ~   ~  ~   ~   ~   ~   ~   ~  
; extreme v9.0
; Email routines
;
;~   ~   ~   ~   ~   ~  ~   ~   ~   ~   ~   ~  
;

; POP3 (check email)
alias checkemail {
  if ($dialog(chemail)) dialog -v chemail
  else _dialog -dm chemail chemail
}
alias qcheck {
  if ($dialog(chemail)) dialog -v chemail
  else chemail $iif($hget(x_email,pop3def),$ifmatch,1) qcheck
}
on *:start:.autocheck

alias autocheck {
  if ($1 == off) {
    _unset email acheck.stat
    .timerpop3-acheck off
    echo -qs Email auto-check is now OFF
    return
  }
  elseif  ($hget(x_email,acheck.stat)) && ($hget(x_email,pop3)) && ($hget(x_email,pop3user)) {
    var %.int = $hget(x_email,acheck.time)
    if (%.int isnum 10-3600) && ($server) {
      .timerpop3-acheck -o 1 %.int chemail $iif($hget(x_email,pop3def),$hget(x_email,pop3def),1) acheck
      echo -qs Email auto-check activated every %.int secs
    }
  }
}

dialog chemail {
  title "Mailbox v3.0"
  size -1 -1 292 236
  option dbu
  icon graphics\mail.ico, 0
  box "", 20, 3 25 285 183
  text "Ready", 1, 122 37 97 9, center
  check "Show RECEIVED header", 2, 8 212 87 7
  check "Show ALL headers", 3, 8 220 84 7
  button "Get mail", 47, 84 34 35 12
  button "Compose", 71, 8 9 30 12
  button "Read #", 40, 41 9 30 12, disable
  button "Reply to", 41, 74 9 30 12, disable
  button "Delete", 42, 107 9 30 12, disable
  button "view", 53, 222 36 20 10, disable
  button "save", 43, 242 36 20 10, disable
  button "close", 44, 262 36 20 10, disable
  button "Config", 49, 247 217 35 12
  button "Close", 50, 209 217 35 12, default
  list 60, 7 48 276 70, extsel
  list 10, 7 110 276 104, hsbar
  icon 48, 267 8 15 15,  graphics\mail.ico, 0
  combo 70, 8 34 72 77, drop
  button "", 100, 0 0 0 0, ok
}

on 1:dialog:chemail:*:* {
  if ($devent == init) {
    mdx.start
    multi.lang
    mdx SetControlMDX 60 listview single rowselect showsel headerdrag report nosortheader > $mdx.vdll
    did -i $dname 60 1 headerdims 20 150 270 90
    did -i $dname 60 1 headertext 0 $chr(35) $+ $chr(9) $+ $_tab(0 From,0 Subject,0 Date)
    if ($hget(x_sets,email1)) did -c chemail 2
    if ($hget(x_sets,email2)) did -c chemail 3
    if ($hget(x_email,pop3acc)) {
      var %a = $ifmatch, %t = $numtok(%a,32), %i = 1
      while (%i <= %t) { did -a chemail 70 $gettok(%a,%i,32) | inc %i }
      did -c chemail 70 $hget(x_email,pop3def)
    }
  }

  if ($devent == sclick) {
    if ($sock(POP3)) {
      var %actual = $_smark(pop3,4)
      if ($did == 40) reademail
      if ($did == 41) && (%actual) replytoemail
      if ($did == 42) && (%actual) deleteemail
      if ($did == 43) && (%actual) saveemail
      if ($did == 44) {
        did1 Socket closed
        did -e chemail 40,41,42,43,60,47,70
        did -ra chemail 50 Close
        resetcheckemail
      }
      if ($did == 60) && ($did(60).seltext) && ($gettok($did(60,1),1,32) == sclick) reademail $gettok($gettok($did(60).seltext,1,9),6,32)
    }
    if ($did == 2) { if ($did(2).state) _set sets email1 on | else _unset sets email1 }
    if ($did == 3) { if ($did(3).state) _set sets email2 on | else _unset sets email2 }
    if ($did == 47) { did -r chemail 60,10 | chemail $did(70).sel }
    if ($did == 53) && ($did(10).lines) viewemail
    if ($did == 49) econf
    if ($did == 50) {
      if ($sock(POP3).status == active) {
        _popsw QUIT
        .timerpop3.close -o 1 3 resetcheckemail
      }
      else {
        resetcheckemail
        dialog -c chemail
      }
    }
    if ($did == 71) email
  }
}
alias -l chemail {
  if ($2) && (($dialog(chemail)) || ($sock(pop3))) {
    if ($2 == acheck) .timer -o 1 10 chemail $1-
    return
  }
  if (($hget(x_email,pop3) = $null) || ($hget(x_email,pop3user) = $null) || ($hget(x_email,pop3pass) = $null)) { econf | return }
  resetcheckemail
  if ($2) set $_v($2) 1
  did1 Connecting to mail server...
  sockopen POP3 $gettok($hget(x_email,pop3),$iif($1 isnum,$1,1),32) 110
  _smark pop3 3 $iif($1 isnum,$1,1)
  if ($dialog(chemail)) .timerpop3.timeout -o 1 40 checktimeout
}

alias -l checktimeout {
  if (!$sock(POP3)) {
    sr -th Error POP3 Server timeout (not responding)
    resetcheckemail
  }
}
alias -l _popsw if ($sock(pop3)) _sw pop3 $1- $+ $crlf
alias -l did1 if ($dialog(chemail)) did -ra chemail 1 $1-
alias -l did10 {
  if (!$dialog(chemail)) return
  var %l = $left($1-,940)
  if ($len(%l) <= 65) did -a chemail 10 %l
  else {
    var %n = 1
    while (%n <= $0) {
      var %line = %line $gettok(%l,%n,32)
      if ($len(%line) >= 70) { did -a chemail 10 %line | unset %line }
      inc %n
    }
    if (%line) did -a chemail 10 %line
  }
}
alias -l did60 if ($dialog(chemail)) did -a chemail 60 $1-

alias -l resetcheckemail {
  if ($dialog(chemail)) {
    if ($_smark(2) != 6) did1 Disconnected
    dialog -t chemail Mailbox: Disconnected
    did -ra chemail 50 Close
    disabledids
    did -e chemail 47,60,70
  }
  unset %.?check
  .timerpop3.* off
  sockclose pop3
}

alias -l disabledids did -b chemail 40,41,42,43,44,53,60,70
alias -l restoredids {
  if ($dialog(chemail)) did -e chemail 40,41,42,43,44,53,60
  _smark 2 0
}

alias -l senduser {
  var %u = $gettok($hget(x_email,pop3user),$_smark(pop3,3),32)
  did1 USER %u
  _popsw USER %u
}
alias -l sendpass {
  if ($hget(x_email,pop3pass)) {
    did1 PASS <hidden>
    _popsw PASS $_pwd($gettok($hget(x_email,pop3pass),$_smark(pop3,3),32))
  }
  else _popsw PASS $$_input(Password (it will not be saved),p,POP3 login)
}

;----------------
alias -l reademail {
  var %n = $iif($1 isnum,$1,$$_input(Enter email number,e,Mailbox))
  _smark pop3 4 %n
  did1 checking message length...
  disabledids
  _smark pop3 2 3
  _popsw LIST %n
}
alias -l deleteemail {
  _popsw DELE $_smark(pop3,4)
  _smark pop3 6 1
}
alias -l replytoemail {
  if (@ !isin $_smark(pop3,10)) var %reply = $_smark(pop3,9)
  else var %reply = $_smark(pop3,10)
  var %subj = $_smark(pop3,8)
  email $remove($wildtok(%reply,*@*,1,32),<,>,") $iif($left(%subj,3) != Re:,Re:) %subj
}
alias -l saveemail {
  var %1 = $iif($1,$1-,$$sfile($getdiremail.txt,Enter filename)), %p = $nofile(%1), %f = $shortfn(%p) $+ $mkfn($nopath(%1))
  savebuf -o chemail 10 %f
  .write %f $cr | sr Email saved to $+ $crlf $+ $nopath(%f)
}
alias -l viewemail {
  var %w = @Email
  if ($window(%w)) clear %w
  else window -k %w
  var %n = 1
  while ($did(10,%n)) { echo %w $ifmatch | inc %n }
  window -b %w
}
;---------------

alias -l checknewmsgs {
  var %a = ( $+ $gettok($hget(x_email,pop3acc),$_smark(pop3,3),32) $+ )

  ; auto-check
  if (%.acheck) {
    if (!%.pop3.emails) { if ($1) sr -t POP3 $+ %a You currently have $1 email(s). | else goto end }
    elseif ($1 > %.pop3.emails) {
      event.sound pager
      sr -t Email!!! $+ %a You have new email(s) [[ $+ $1 $+ ]] $+ . $+ $lf $+ $lf $+ (Control-F12 to open email dialog)
      set -u60 %.checkmail 1
    }
    if ($server) set %.pop3.emails $1
    :end
    .autocheck
    _popsw QUIT
    .timerpop3.quit -o 1 3 resetcheckemail
    return
  }

  ; quick check
  if (%.qcheck) {
    sr -t POP3 $+ %a You have $1 email(s).
    unset %.qcheck
    _popsw QUIT
    .timerpop3.quit -o 1 3 resetcheckemail
    return
  }

  ; normal dialog check
  did1 You have $1 $iif($1 == 1,message,messages)
  if ($1 == 0) {
    _popsw QUIT
    _smark 2 6
    .timerpop3.quit -o 1 3 resetcheckemail
  }
  else {

    ; made this to delete all my emails (when inbox full or something)
    ;var %del = 1
    ;while (%del <= $1) { _popsw DELE %del | inc %del }
    ;_popsw QUIT
    ;return

    _smark 4 0
    _smark 5 $1
    _smark 2 2
    _smark 7 1
    set %.pop3.emails $1
    _popsw TOP 1 0
  }
}

on 1:sockopen:POP3:{
  .timerpop3.timeout off
  if ($sockerr) {
    unset %.?check
    did1 $_sockerr
    return
  }
  _smark 1 0
  _smark 2 1
  did1 Connection established
  if ($dialog(chemail)) {
    disabledids
    did -ra chemail 50 Disconnect
    did -b chemail 47
    dialog -t chemail Mailbox: Connected
  }
}

on 1:sockread:POP3 {
  if ($sockerr) return
  ;smark 1:status_login 2:status_global 3: 4:actual_msg 5:total_msgs 6:delete_msg 7:tmp_counter 8:rcvd_from 9:rcvd_subj 10:rcvd_date
  var %p, %s = $_smark(2)
  :next
  sockread %p
  if ($sockbr = 0) return
  if (%debug) _wecho %p

  if (%s == 1) {
    if (-ERR* iswm %p) && ($dialog(chemail)) {
      did1 $gettok(%p,2-,32)
      restoredids
      did -e chemail 47,70
      resetcheckemail
    }
    elseif (+OK* iswm %p) { 
      if ($_smark(1) == 0) { senduser | _smark 1 1 }
      elseif ($_smark(1) == 1) { sendpass | _smark 1 2 }
      elseif ($_smark(1) == 2) {
        if ($gettok(%p,4,32) isnum) { checknewmsgs $gettok(%p,4,32) | _smark 1 0 | return }
        _popsw stat
        _smark 1 3
      }
      elseif ($_smark(1) == 3) { _smark 1 4 | checknewmsgs $gettok(%p,2,32) }
    }
  }
  elseif (%s == 2) {
    if ($_smark(7) == 1) did1 Retrieving headers...

    if (!%p) && ($_smark(8)) {
      did60 0 + 0 0 0 $_smark(7) $+ $chr(9) $+ 0 $iif($_smark(8),$ifmatch,n/a) $+ $chr(9) $+ 0 $iif($_smark(9),$ifmatch,n/a) $+ $chr(9) $+ 0 $asctime($_smark(10),dd/mm/yy HH:nn)
      did1 Retrieving headers... ( $+ $_smark(7) of $_smark(5) $+ )
      _smark 8 0
      _smark 9 0
      _smark 10 0
      _smark 7 $calc($_smark(7) +1)

      if ($_smark(7) <= $_smark(5)) _popsw TOP $_smark(7) 0
      else {
        _smark 7 0
        _smark 8 0
        _smark 9 0
        _smark 10 0
        var %nmsgs = $_smark(5)
        did1 Ready ( $+ %nmsgs message $+ $iif(%nmsgs != 1,s) $+ )
        restoredids
      }
      return
    }

    elseif (From:* iswm %p) {
      if (iso isin %p) || (? isin %p) var %from = $gettok(%p,-1,32)
      else var %from = $gettok(%p,2-,32)
      if (" isin %from) %from = $gettok(%from,1,34)
      elseif ($numtok(%from,32) > 1) && (*<*@*> iswm %from) %from = $deltok(%from,-1,32)
      _smark 8 %from
    }
    elseif (Subject:* iswm %p) _smark 9 $left($gettok(%p,2-,32),30)
    elseif (Date:* iswm %p) _smark 10 $ctime($gettok(%p,3-6,32))
  }
  elseif (%s == 3) {
    if ($_string(+OK & &) iswm %p) {
      var %mbytes = $gettok(%p,3,32)
      if (%mbytes isnum) && (%mbytes > 30000) {
        did1 Message $_smark(4) is too big ( $+ $bytes(%mbytes,3).suf $+ )
        restoredids
      }
      else {
        did1 Retrieving message... ( $+ $bytes(%mbytes,3).suf $+ )
        _popsw RETR $gettok(%p,2,32)
        did -r chemail 10
        _smark 2 4
      }
    }
    elseif (-ERR* iswm %p) { did1 $gettok(%p,2-,32) | restoredids }
  }
  elseif (%s == 4) {
    var %t1 = $gettok(%p,1,32)
    if (!%p) {
      dialog -t chemail Mailbox: $_smark(8) ( $+ $_smark(9) $+ )
      _smark 2 5
      did10 $str(-,40)
      return
    }
    ;8:lastsubject 9:lastsender 10:lastreplyto
    elseif (%t1 == Subject:) { did10 %p | _smark 8 $gettok(%p,2-,32) }
    elseif (%t1 == From:) { did10 %p | _smark 9 $remove($gettok(%p,2-,32),") }
    elseif (%t1 == Reply-to:) { did10 %p | _smark 10 $gettok(%p,2-,32) }
    elseif (%t1 == To:) did10 %p
    elseif (%t1 == CC:) did10 %p
    elseif (%t1 == Date:) did10 %p
    elseif (%t1 == Received:) {
      if ($hget(x_sets,email1)) did10 %p
      goto next
    }
    elseif ($hget(x_sets,email2)) && (+ok* !iswm %p) did10 %p
    goto next
  }
  elseif (%s == 5) {
    if (%p == .) {
      did1 Message $_smark(4) of $_smark(5)
      restoredids
      return
    }
    else did10 $iif(%p,%p,$chr(160))
    goto next
  }
  else {
    if ($_smark(6)) && (+OK* iswm %p) {
      if ($did(chemail,60).sel) did -d chemail 60 $ifmatch
      did1 Message deleted
      if ($calc(%.pop3.emails -1)) set %.pop3.emails $ifmatch
      _smark 5 $calc($_smark(5) -1)
      if ($dialog(chemail)) did -r chemail 10
      if ($_smark(5) == 0) {
        did1 No more messages in server
        disabledids
        _popsw QUIT
        _smark 2 6
        .timerpop3.quit -o 1 3 resetcheckemail
      }
      _smark 6 0
    }
    elseif (-ERR* iswm %p) did1 $gettok(%p,2-,32)
    if ($dialog(chemail)) dialog -t chemail Mailbox: Connected
  }
}
on 1:sockclose:POP3:resetcheckemail


;=================================
;email send

;$_getnextd(dname) returns next available dialog with name dname.N
alias -l _getnextd {
  var %n = 1
  while ($dialog($+($1,%n))) { inc %n }
  return $+($1,%n)
}

alias email {
  var %d = $_getnextd(smtp.email.)
  dialog -dm %d email
  if ($1) {
    did -ra %d 2 $1
    did -c %d 2 1
    did -f %d 8
  }
  if ($2-) {
    did -ra %d 8 $2-
    did -f %d 10
    dialog -t %d $2-
    did -c %d 2 1
  }
}

dialog email {
  title "Email Send v3.0"
  size -1 -1 230 209
  option dbu
  icon graphics\mail.ico, 0
  box "Header", 20, 5 3 220 39
  text "Send to:", 1, 15 14 30 10, right
  combo 2, 48 12 130 100, edit drop
  text "From:", 3, 15 26 30 10, right
  combo 4, 48 25 130 100, edit drop
  text "Subject:", 7, 12 65 30 10, right
  edit "", 8, 47 64 164 10, autohs
  edit "", 10, 10 79 210 101, multi return vsbar
  button "Send", 50, 61 190 35 12, default
  button "Close", 49, 100 190 35 12
  button "Config", 48, 138 190 35 12
  button "", 51, 0 0 0 0, cancel
  box "", 21, 5 38 220 16
  text "Ready", 9, 9 44 211 7, center
  box "", 22, 5 50 220 135
  icon 40, 194 15 15 15,  graphics\letter.ico, 0
}

on 1:dialog:smtp.email.*:*:* {
  if ($devent == init) {
    multi.lang
    if ($hget(x_email,recemails)) didtok $dname 2 44 $ifmatch
    if ($hget(x_email,myemail)) {
      didtok $dname 4 44 $ifmatch
      did -c $dname 4 1
    }
    else did -ra $dname 4 $_myemail
  }
  if ($devent == edit) && ($did == 8) dialog -t $dname $iif($remove($did(8),$chr(32)),$did(8),Email Send v2.5)
  if ($devent == sclick) {
    if ($did == 50) { if ($did(10).lines) {
        if (*@* iswm $did(2)) _set email recemails $qtok($hget(x_email,recemails),$did(2),10,44)
        smtp.send $dname $did(2)
      }
      else sr -th Error Parameters missing.
    }
    if ($did == 49) || ($did == 51) {
      if ($sock($dname)) {
        sockclose $dname
        did -ra $dname 49 Close
        did -e $dname 50
      }
      else dialog -x $dname
    }
    if ($did == 48) econf
  }
}

alias qmail {
  if (*@* iswm $1) var %a = $1
  else var %a = $$_input(Email to,e,Qmail)
  if ($2) var %m = $2-
  else var %m = $$_input(Enter message,e,Qmail)
  if (%a) && (%m) {
    smtp.send qmail %a %m
    se * QMAIL to %a $+ : %m
  }
}

alias smtp.send {
  if (!$hget(x_email,smtp)) { econf | return }
  if ($1 == qmail) var %sock = smtp.qmail. $+ $rand(111,999)
  else var %sock = $1

  if ($sock(%sock)) { sr -th Error SMTP Socket in use. | return }
  if (*@* !iswm $2) { sr -th Error Invalid email address | return }

  sockopen %sock $gettok($hget(x_email,smtp),1,44) 25
  ; 1:status 2:sent 3:send_to 4:subject 5:data (if qmail)
  sockmark %sock 00 $+ $2


  if ($dialog(%sock)) {
    _smark %sock 4 $did($1,8)
    did -ra $1 9 Connecting...
    did -b $1 50
    did -ra $1 49 Cancel
  }
  else {
    _smark %sock 4 $left($3-,15) $+ ...
    _smark 5 $left($3-,900)
  }
}
alias -l _ssmtp if ($sock($sockname)) _sw $sockname $1-
on 1:sockopen:smtp.*:{
  if ($sockerr) {
    sr -th Error Cannot connect.
    if ($dialog($sockname)) {
      did -ra $sockname 9 Error
      did -ra $sockname 49 Close
      did -e $sockname 50
    }
  }
}
on 1:sockclose:smtp.*:{
  if ($_smark(2)) {
    if ($dialog($sockname)) {
      did -ra $sockname 9 Email Sent
      did -e $sockname 50
      did -ra $sockname 49 Close
    }
    else se * SMTP message sent
  }
}
on 1:sockread:smtp.*:{
  var %sm
  sockread %sm
  if (%debug) _wecho %sm
  if ($dialog($sockname)) did -ra $sockname 9 $left(%sm,100)
  if (220* iswm %sm) smtp-logon 0
  elseif (354* iswm %sm) smtp-sendmail
  elseif (250* iswm %sm) {
    if ($_smark(1)) {
      _smark 1 $calc($ifmatch +1)
      smtp-logon $_smark(1)
    }
    elseif ($_smark(2)) _ssmtp QUIT
  }
  elseif (5* iswm %sm) || (4* iswm %sm) smtp-error $gettok(%sm,2-,32)
}
alias -l smtp-logon {
  if ($1 == 0) { _ssmtp HELO $_myip | _smark 1 1 }
  elseif ($1 == 2) _ssmtp MAIL FROM: $_myemail
  elseif ($1 == 3) _ssmtp RCPT TO: $_smark(3)
  elseif ($1 == 4) { _ssmtp DATA | _smark 1 0 }
}

alias -l _myip {
  if ($ip) return $ifmatch
  if ($__i(myaddress)) return $gettok($__i(myaddress),2,64)
  return 127.0.0.1
}
alias -l _myemail {
  if ($dialog(email)) && (@ isin $did(email,4)) return $did(email,4)
  if ($hget(x_email,myemail)) return $gettok($ifmatch,1,44)
  return $+($me,@extreme.com)
}

alias -l smtp-sendmail {
  if ($dialog($sockname)) did -ra $sockname 9 Sending...

  _ssmtp From: $iif($hget(x_email,myname),$ifmatch,$me) $+(<,$_myemail,>)
  _ssmtp X-Mailer: eXtreme $xtreme.ver
  _ssmtp To: $_smark(3)
  _ssmtp Subject: $iif($_smark(4),$ifmatch,<no subject>)
  _ssmtp $cr

  if (($dialog($sockname)) && ($did($sockname,10).lines)) {
    var %j = 1
    while (%j <= $did($sockname,10).lines) { _ssmtp $did($sockname,10,%j) | inc %j }

    ;signature file
    var %file = $iif($hget(x_email,signature),$ifmatch,system\sign.txt)
    if ($isfile(%file)) {
      var %l = $lines(%file), %n = 1
      while (%n <= %l) { _ssmtp $read(%file,%n) | inc %n }
    }
  }
  elseif ($_smark(5) != $null) _ssmtp $ifmatch
  _ssmtp .
  _smark 2 1
}
alias -l smtp-error {
  if ($dialog($sockname)) {
    did -ra $sockname 9 Error
    did -e $sockname 50
    did -ra $sockname 49 Close
    sr -th Error $1-
  }
  sockclose $sockname
}

;====================
;email config

alias econf var %a = $_dialog(econ,econ,-4)
dialog econ {
  title "Email Setup"
  size -1 -1 234 121
  option dbu
  icon graphics\mailbox, 0
  button "Ok", 250, 76 104 35 12, default ok
  button "Cancel", 249, 116 104 35 12, cancel
  tab "SMTP", 81, 9 7 216 91
  combo 1, 68 37 123 80, tab 81 edit drop
  combo 2, 68 71 123 80, tab 81 edit drop
  text "SMTP Server", 3, 18 38 44 10, tab 81 right
  text "Your name", 5, 19 59 43 10, tab 81 right
  text "Your email", 4, 19 73 43 10, tab 81 right
  edit "", 6, 68 57 122 11, tab 81
  tab "Signature", 83
  text "Enter your signature here (or choose a file below)", 41, 33 31 169 10, tab 83
  edit "", 42, 31 41 171 34, tab 83 multi return vsbar
  check "Use text file instead", 43, 32 80 73 10, tab 83
  edit "", 44, 107 80 94 10, disable tab 83 autohs
  tab "Accounts", 82
  list 21, 19 30 42 65, tab 82
  edit "", 22, 100 31 66 10, tab 82 autohs
  edit "", 23, 100 48 110 10, tab 82 autohs
  edit "", 24, 100 63 60 10, tab 82 autohs
  edit "", 25, 100 74 60 10, tab 82 pass autohs
  text "Account", 26, 64 33 34 8, tab 82 right
  text "POP3 Server", 27, 64 50 34 8, tab 82 right
  text "Username", 28, 64 65 34 8, tab 82 right
  text "Password", 29, 64 76 34 8, tab 82 right
  button "Add", 30, 182 63 28 10, tab 82
  button "Update", 31, 182 73 28 10, disable tab 82
  button "Delete", 32, 182 83 28 10, disable tab 82
  tab "Misc", 85
  text "Set default POP3 account", 90, 14 43 90 10, tab 85 right
  combo 91, 111 41 90 60, tab 85 drop
  check "Autocheck email every", 92, 40 61 64 10, tab 85
  text "seconds", 93, 133 63 20 10, tab 85
  edit "", 94, 111 61 20 10, disable tab 85 autohs
}

on 1:dialog:econ:*:*:{
  if ($devent == init) {
    multi.lang
    if ($hget(x_email,smtp)) { didtok econ 1 44 $ifmatch | did -c econ 1 1 }
    if ($hget(x_email,myemail)) { didtok econ 2 44 $ifmatch | did -c econ 2 1 }
    if ($hget(x_email,myname)) did -ra econ 6 $ifmatch
    if ($isfile(system\sign.txt)) loadbuf -or econ 42 system\sign.txt
    if ($hget(x_email,signature)) { did -a econ 44 $ifmatch | did -c econ 43 | did -e econ 44 | did -b econ 42 }
    if ($hget(x_email,pop3acc)) didtok econ 21 32 $ifmatch
    if ($hget(x_email,acheck.stat)) { did -c econ 92 | did -e econ 94 }
    if ($hget(x_email,acheck.time)) did -a econ 94 $ifmatch
    did -f econ 1
  }
  if ($devent == edit) && ($did isnum 22-25) && ($did(21).sel) did -e econ 31
  if ($devent == sclick) {
    if ($did == 21) {
      did -e econ 32
      var %n = $findtok($hget(x_email,pop3acc),$did(21,$did(21).sel),32)
      did -ra econ 22 $did(21,$did(21).sel)
      did -ra econ 23 $gettok($hget(x_email,pop3),%n,32)
      did -ra econ 24 $gettok($hget(x_email,pop3user),%n,32)
      did -ra econ 25 $_pwd($gettok($hget(x_email,pop3pass),%n,32))
    }
    if ($did == 85) { did -r econ 91 | var %l = $did(21).lines, %n = 1 | while (%n <= %l) { did -a econ 91 $did(21,%n) | inc %n } | did -c econ 91 $hget(x_email,pop3def) }
    if ($did == 30) && ($_isnotinlist($dname,21,$did(22))) && ($did(22)) && ($did(23)) && ($did(24)) && ($did(25)) _addacc $did(23) $did(24) $did(25) $did(22)
    if ($did == 31) && ($did(21).sel) && ($did(22)) && ($did(23)) && ($did(24)) && ($did(25)) {
      _remacc $did(21,$did(21).sel)
      did -d econ 21 $did(21).sel
      _addacc $did(23) $did(24) $did(25) $did(22)
      did -b econ 31
    }
    if ($did == 32) && ($did(21).sel) { _remacc $did(22) | did -d econ 21 $did(21).sel | did -r econ 22,23,24,25 | did -b econ 32 }
    if ($did == 43) { if ($did(43).state) { did -e econ 44 | did -b econ 42 } | else { did -b econ 44 | did -e econ 42 } }
    if ($did == 70) { if ($did(70).state) { did -e econ 71,72 | if ($did(72).state == 0) did -c econ 71 | else did -e econ 73 } | else did -b econ 71,72,73 }
    if ($did == 71) did -b econ 73
    if ($did == 72) did -e econ 73
    if ($did == 92) { if ($did(92).state) did -e econ 94 | else did -b econ 94 }
    if ($did == 250) {
      if ($did(1)) _sm smtp $qtok($hget(x_email,smtp),$did(1),10,44)
      if ($did(2)) _sm myemail $qtok($hget(x_email,myemail),$did(2),10,44)
      if ($did(6)) _sm myname $ifmatch
      if ($did(43).state) && ($did(44)) _sm signature $did(44)
      else _-unset email signature
      if (!$did(42)) .remove system\sign.txt
      else {
        var %l = $did(42).lines, %n = 1
        .remove system\sign.txt
        while (%n <= %l) { .write -a system\sign.txt $did(42,%n) | inc %n }
      }
      if ($did(91).sel) _sm pop3def $ifmatch 
      if ($did(92).state) && ($did(94)) {
        _sm acheck.stat 1
        _sm acheck.time $did(94)
        .autocheck
      }
      else {
        _-unset email acheck.stat
        .timerpop3-acheck off
      }
      hupd
    }
  }
}
alias -l _sm _-set email $1-
alias -l _addacc {
  var %n = $calc($numtok($hget(x_email,pop3acc),32) +1)
  _-set email pop3acc $addtok($hget(x_email,pop3acc),$4-,32)
  _-set email pop3 $instok($hget(x_email,pop3),$1,%n,32)
  _-set email pop3user $instok($hget(x_email,pop3user),$2,%n,32)
  _-set email pop3pass $instok($hget(x_email,pop3pass),$_pwd($3),%n,32)
  did -a econ 21 $4-
}
alias -l _remacc {
  var %n = $findtok($hget(x_email,pop3acc),$1-,1,32)
  if ($deltok($hget(x_email,pop3acc),%n,32)) _-set email pop3acc $ifmatch
  else _-unset email pop3acc
  if ($deltok($hget(x_email,pop3),%n,32)) _-set email pop3 $ifmatch
  else _-unset email pop3
  if ($deltok($hget(x_email,pop3user),%n,32)) _-set email pop3user $ifmatch
  else _-unset email pop3user
  if ($deltok($hget(x_email,pop3pass),%n,32)) _-set email pop3pass $ifmatch
  else _-unset email pop3pass
}




;
;EOF
