;~   ~   ~   ~   ~   ~  ~   ~   ~   ~   ~   ~  
; extreme v9.0
; TCP/IP routines
;
;~   ~   ~   ~   ~   ~  ~   ~   ~   ~   ~   ~  
;
;identd server
alias _identd {
  if ($1 == off) { sockclose identdl | .timeridentdl off | return }
  elseif ($portfree(113)) socklisten identdl 113
  .timeridentdl -o 1 60 sockclose identdl
}
on 1:socklisten:identd*:{
  sockaccept identda. $+ $rand(100,999)
  if ($sock(identda.*,0) >= 30) sockclose identd*
}
on 1:sockread:identda.*:{
  var %i
  sockread %i
  var %1 = $remove($gettok(%i,1,44),$chr(32)), %2 = $remove($gettok(%i,2,44),$chr(32)), %id = $iif($hget(x_sets,identd-user),$ifmatch,$gettok($emailaddr,1,64))
  if (%1 isnum) && (%2 isnum) _sw $sockname %2 $+ , %1 : USERID : UNIX : %id
  .timer -o 1 5 sockclose $sockname
}

;-------------------------

;portscan

dialog pscan {
  title "Port Scan v3.6"
  size -1 -1 168 203
  option dbu
  icon graphics\telnet.ico, 0
  text "Host", 1, 6 6 12 7
  edit "", 2, 20 5 109 10, autohs
  text "Start port", 3, 6 18 25 7
  edit "1", 4, 31 16 25 10, autohs
  text "Stop port", 5, 6 29 25 7
  edit "65535", 6, 31 27 25 10, autohs
  text "Delay-(ms)", 7, 76 18 27 7
  edit "50", 8, 104 16 25 10, autohs
  text "Open socks", 9, 71 29 31 7
  edit "0", 10, 104 27 25 10, disable autohs
  button "Start", 12, 133 5 30 10
  button "Halt", 11, 133 16 30 10
  button "Close", 17, 133 27 30 10
  list 13, 5 55 158 122, extsel
  check "Save to", 14, 6 173 31 7
  edit "", 15, 37 172 115 10, autohs
  button "Clear window", 16, 59 188 40 10
  check "Use ports from file", 18, 6 44 62 7
  edit "", 19, 69 42 50 10, disable autohs
  button "!", 20, 120 42 9 10, disable
  button "", 56, 0 0 0 0, ok
  button "", 57, 0 0 0 0, cancel
}
on 1:dialog:pscan:*:*:{
  if ($devent == init) {
    multi.lang
    did -ra pscan 15 system\scanlog.log
    did -ra pscan 19 system\ports.txt
    if ($numtok($cb,32) == 1) && ($_isserv($cb)) && ($cb != $did(2)) did -ra pscan 2 $cb
    else did -ra pscan 2 127.0.0.1
    pscan.sv Portscan ready.
  }
  if ($devent == sclick) {
    if ($did == 12) && ($sock(pscan.*,0) == 0) {
      if ($_isserv($did(2))) {
        sockclose pscan.*
        did -ra pscan 17 Reset
        did -b pscan 2,4,6,8,14,15
        .timerpscan.socks -o 0 1 pscan.sockupd
        if ($did(18).state) && ($read($did(pscan,19),1) isnum) did -ra pscan 4 $ifmatch
        pscan.sv Scanning host ( $+ $did(2) $+ )
        pscan.sv Scan begun on port ( $+ $did(4) $+ )
        .timerpscan.uncon -o 1 5 pscn.uncon
        pscan.open $did(2) $did(4) $did(8) 1 $lines($did(19))
      }
      else sr Missing/invalid hostname
    }
    if ($did == 11) && ($sock(pscan.*,0)) { pscan.sv Scan halted on port ( $+ $did(4) $+ ) | pscn.end }
    if ($did == 17) || ($did == 57) {
      if ($sock(pscan.*,0)) {
        pscan.sv All sockets closed.
        sockclose pscan.*
        .timerpscan.uncon -o 1 3 pscn.uncon
      }
      else dialog -k pscan
    }
    if ($did == 16) did -r pscan 13
    if ($did == 18) {
      if ($did(18).state) { did -b pscan 4,6 | did -e pscan 19,20 }
      else { did -e pscan 4,6 | did -b pscan 19,20 }
    }
    if ($did == 20) && ($isfile($did(19))) run notepad $did(19)
  }
}
alias pscan _dialog -dm pscan pscan
alias -l pscan.open {
  if (!$dialog(pscan)) { pscn.end | return }
  var %lsock = $calc($2 - 80), %4 = $calc($4 +1)
  if ($sock(pscan.*,0) >= 80) && ($sock( [ pscan. [ $+ [ %lsock ] ] ] ).status == connecting) sockclose pscan. $+ %lsock
  if ($2 isnum 1-65535) sockopen pscan. $+ $2 $1-2

  if ($did(pscan,18).state) { if (%4 <= $5) var %next = $read($did(pscan,19),%4) }
  elseif ($calc($2 +1) <= $did(pscan,6)) var %next = $ifmatch

  if (%next) { did -ra pscan 4 %next | .timerpscan. $+ %4 -om 1 $3 pscan.open $1 %next $3 %4 $5 }
  else { pscan.sv Scan ended on port ( $+ $2 $+ ) | pscn.end 10 }
}
alias -l pscan.sockupd if ($dialog(pscan)) did -ra pscan 10 $sock(pscan.*,0) | else pscn.end
alias -l pscan.sv {
  did -a pscan 13 $1-
  if ($did(pscan,14).state == 1) && ($did(pscan,15)) write $shortfn($nofile($did(pscan,15))) $+ $nopath($did(pscan,15)) $1-
}
alias -l pscn.end {
  .timer -o 1 $iif($1 isnum,$1,0) sockclose pscan.*
  .timerpscan.* off
  if ($dialog(pscan)) {
    did -ra pscan 10 0
    did -ra pscan 17 Close
    did -e pscan 2,4,6,8,14,15
  }
}
alias -l pscn.uncon if ($sock(pscan.*,0) <= 1) { sr -th Error Unable to connect | pscn.end }

on 1:sockopen:pscan*:{
  if ($sockerr) return
  pscan.sv $sock($sockname).port :CONNECTED
  .timer $+ $sockname -o 1 10 sockclose $sockname
}
on 1:sockclose:pscan*:pscan.sv $sock($sockname).port :CLOSED
on 1:sockread:pscan*:{
  if ($sockerr) return
  :next
  var %s
  sockread %s
  if ($sockbr == 0) return
  var %len = $calc(%len + $len(%s))
  if (%len > 500) { pscan.sv $sock($sockname).port :CLOSED (flooding) | sockclose $sockname | return }
  if (!%s) var %s -
  pscan.sv $sock($sockname).port : $+ %s
  goto next
}

;-----------------------
;portlisten

on *:connect:.plisten start $hget(x_plisten,ports) | _unset plisten log

alias pl _dialog -dm plisten plisten
alias plisten {
  if ($1 == close) { sockclose pl.* | echo -qs (Portlisten) All sockets closed | return }
  if ($1 == start) { if ($hget(x_plisten,onstart) != 1) || (!$2) return | sle Initializing portlistener... ( $+ $numtok($2,44) ports) | .timer 1 0 .plisten $2 | return }
  var %n = $numtok($1,44)
  while (%n) {
    var %tok = $gettok($1,%n,44), %p = $gettok(%tok,2,58), %pr = $gettok(%tok,1,58) | if (%p !isnum 1-65536) { if ($show) sle Invalid port %p | goto next }
    if ($sock($+(pl.,%pr,.,%p))) goto next | if ($portfree(%p) == $false) { echo -qs (Portlisten) Port already in use %p | goto next }
    if (%pr == tcp) _scklt pl.tcp. $+ %p %p | else _scklu pl.udp. $+ %p %p
    if ($dialog(plisten)) { did -a plisten 1 $lower(%pr) $+ : $+ %p | did -r plisten $iif(%pr == tcp,4,5) | did -b plisten $iif(%pr == tcp,2,3) }
    else echo -qs (Portlisten) Watching port %p for $upper(%pr) connections/scans
    :next | dec %n
  }
}
alias -l _scklt if (!$sock($1)) && ($portfree($2)) socklisten $1-
alias -l _scklu if (!$sock($1)) && ($portfree($2)) sockudp -k $1-
alias -l __srefresh {
  did -r plisten 1
  var %t = $sock(pl.*,0)
  while (%t) {
    did -a plisten 1 $gettok($sock(pl.*,%t),2,46) $+ : $+ $sock(pl.*,%t).port
    dec %t
  }
}
alias -l _updlog {
  if ($dialog(plisten)) {
    did -r plisten 22
    var %l = $hget(x_plisten,log), %n = 1
    while (%n <= $numtok(%l,59)) {
      var %a = $gettok(%l,%n,59)
      did -a plisten 22 $asctime($gettok(%a,1,45),[dd/mm HH:nn:ss]) $replace($gettok(%a,2,45),.,:) by $gettok(%a,3,45)
      inc %n
    }
    did -z plisten 22
  }
}
alias -l _slog {
  var %f = $$sfile(logs\connects.log,Select logfile), %n = 1
  while (%n <= $did(plisten,22).lines) {
    .write $+(",%f,") $did(plisten,22,%n)
    inc %n
  }
  did -f plisten 25
  sr Log saved to logs\connects.log
}

dialog plisten {
  title "Port Listener v2.3"
  size -1 -1 199 149
  option dbu
  icon graphics\telnet.ico, 0
  tab "Setup", 101, 5 7 187 115
  list 10, 136 33 43 75, tab 101 sort
  list 1, 17 33 43 75, tab 101 sort
  text "TCP", 8, 74 41 12 7, tab 101
  text "UDP", 9, 74 54 12 7, tab 101
  button "Add", 2, 110 41 16 8, disable tab 101
  button "Add", 3, 110 53 16 8, disable tab 101
  edit "", 4, 87 40 20 10, tab 101
  edit "", 5, 87 52 20 10, tab 101
  button "Close", 12, 62 97 25 10, tab 101
  button "Close all", 49, 62 107 25 10, tab 101
  button "<--", 11, 80 70 40 9, tab 101
  button "Refresh", 13, 18 107 41 10, tab 101
  check "Add to list", 14, 137 107 41 10, tab 101 push
  text "Listening:", 16, 17 25 25 7, tab 101
  text "Ports:", 17, 136 25 25 7, tab 101
  tab "Attempts", 102
  text "Connection Attempts:", 21, 15 25 80 7, tab 102
  list 22, 12 33 173 75, tab 102 hsbar
  button "Clear", 23, 165 108 20 10, tab 102
  button "Save", 25, 144 108 20 10, tab 102
  button "Clip", 24, 123 108 20 10, tab 102
  check "Active on startup", 6, 7 126 60 7
  check "Pop up warning dialog", 15, 7 134 65 7
  button "Ok", 50, 156 132 35 12, default ok
}
on 1:socklisten:pl.tcp.*:{
  sockaccept $sockname $+ a
  flash WARNING
  var %ip = $sock( [ $sockname $+ a ] ).ip
  _set plisten log $qtok($hget(x_plisten,log),$+($ctime,-,$right($upper($sockname),-3),-,%ip),14,59)
  sae ( $+ $_c(2) $+ WARNING $+ ) TCP port $sock($sockname).port reached by %ip $iif($server,(Press CtrlF7 to look for offender))
  set -u60 $_i(iptrace.ip) %ip
  if (!$hget(x_plisten,nopopup)) sr -t Warning TCP connection attempt detected $+ $crlf $+ on port $sock($sockname).port $+ $crlf $+ %ip
  event.sound warning
  .timer -o 1 10 _scklt $sockname $sock($sockname).port
  sockclose $sockname $+ *
  _updlog
}
on 1:udpread:pl.udp.*:{
  flash WARNING
  var %ip = $iif($sock($sockname).saddr,$sock($sockname).saddr,<n/a>)
  _set plisten log $qtok($hget(x_plisten,log),$+($ctime,-,$right($upper($sockname),-3),-,%ip),14,59)
  sae ( $+ $_c(2) $+ WARNING $+ ) UDP port $sock($sockname).port reached by %ip $iif(($server && $sock($sockname).saddr),(Press CtrlF7 to look for offender))
  if ($sock($sockname).saddr) set -u60 $_i(iptrace.ip) $ifmatch
  if (!$hget(x_plisten,nopopup)) sr -t Warning UDP packet detected $+ $crlf $+ on port $sock($sockname).port $+ $crlf $+ %ip
  event.sound warning
  .timer -o 1 10 _scklu $sockname $sock($sockname).port
  sockclose $sockname
  _updlog
}
on 1:dialog:plisten:*:*:{
  if ($devent == init) {
    multi.lang
    if ($hget(x_plisten,list)) didtok plisten 10 44 $hget(x_plisten,list)
    else didtok plisten 10 44 tcp:21,tcp:23,tcp:25,tcp:59,tcp:80,tcp:139,tcp:1024,tcp:8080,tcp:12345,udp:31337
    __srefresh
    if ($hget(x_plisten,onstart)) did -c plisten 6
    if (!$hget(x_plisten,nopopup)) did -c plisten 15
    _updlog
  }
  if ($devent == edit) {
    if ($did(4) isnum 1-65536) did -e plisten 2
    else did -b plisten 2
    if ($did(5) isnum 1-65536) did -e plisten 3
    else did -b plisten 3
  }
  if ($devent == dclick) && ($did == 10) plisten $did(10).seltext
  if ($devent == sclick) {
    if ($did == 2) {
      if ($did(14).state) {
        did -a plisten 10 tcp: $+ $did(4)
        did -r plisten 4,5
        did -b plisten 2,3
      }
      else plisten tcp: $+ $did(4)
    }
    if ($did == 3) {
      if ($did(14).state) {
        did -a plisten 10 udp: $+ $did(5)
        did -r plisten 4,5
        did -b plisten 2,3
      }
      else plisten udp: $+ $did(5)
    }
    if ($did == 11) && ($did(10).sel) plisten $did(10).seltext
    if ($did == 12) {
      if ($did(14).state) && ($did(10).sel) did -d plisten 10 $did(10).sel
      elseif ($did(1).sel) {
        sockclose pl. $+ $gettok($did(1).seltext,1,58) $+ . $+ $gettok($did(1).seltext,2,58)
      did -d plisten 1 $did(1).sel }
    }
    if ($did == 13) __srefresh
    if ($did == 14) {
      if ($did(14).state) { did -b plisten 1,6,11,13,49 | did -ra plisten 12 Remove }
      else { did -e plisten 1,6,11,13,49 | did -ra plisten 12 Close }
    }
    if ($did == 23) { _unset plisten log | did -r plisten 22 }
    if ($did == 24) && ($did(22).sel) clipboard $did(22).seltext
    if ($did == 25) && ($did(22).lines) _slog
    if ($did == 49) { sockclose pl.* | __srefresh }
    if ($did == 50) {
      if ($did(6).state) _set plisten onstart 1 | else _unset plisten onstart
      if ($did(15).state) _unset plisten nopopup | else _set plisten nopopup 1
      var %n = $did(1).lines
      while (%n) { var %l = $addtok(%l,$did(1,%n),44) | dec %n }
      var %n = $did(10).lines
      while (%n) { var %l2 = $addtok(%l2,$did(10,%n),44) | dec %n }
      if (%l) _set plisten ports %l | else _unset plisten ports
      if (%l2) _set plisten list %l2 | else _unset plisten list
    }
  }
}

;--------------------

;nickfinder
alias nfind {
  if ($1) && ($hget(x_misc,nfind)) _nfind $1 $ifmatch
  elseif (!$dialog(nfind)) {
    _loadservers
    _dialog -m nfind nfind
  }
}
alias -l _nfind {
  var %w = $w($1)
  if ($window(%w)) window -c %w
  sockclose $+(nf-,$1,-*)
  var %l = $hget(x_misc,nfind), %n = $numtok(%l,172)
  window -kl -t25 %w $_gcoord(nickfinder,-1 -1 400 200) @nfind $_@font
  aline %w $chr(9)
  aline %w $_c(1) $+ Server $chr(9) $_c(1) $+ Status
  aline %w $chr(9)
  _identd
  while (%n) {
    var %m = $gettok(%l,%n,172)
    aline %w $gettok(%m,1,32) $chr(9) waiting for reply
    _conn $1 $gettok($gettok(%m,1,32),2,58) $gettok(%m,2,32)
    dec %n
  }
}
alias -l w return @NickFinderresultsfor $+ $1
alias -l _conn {
  if ($2) {
    var %s = $+(nf,$1,,$2)
    if ($sock(%s)) sockclose %s
    sockopen %s $2 $iif($3,$3,6667)
    .timer $+ %s -o 1 90 _nfcancl %s
  }
}
alias -l _nfcancl if ($sock($1)) { var %w = $w($gettok($1,2,173)) | sockclose $1 | if ($window(%w)) titlebar %w (timeout) }
alias -l _result {
  var %w = $w($gettok($sockname,2,173))
  if ($window(%w)) _res2 $gettok($sockname,-1,173) $1-
  .timer $+ $sockname off
  sockclose $sockname
}
alias -l _res2 {
  var %w = $w($gettok($sockname,2,173))
  if ($fline(%w,$+(*:,$1,*))) {
    var %n = $ifmatch
    if ($2 == -) var %l = error
    elseif ($2 == +) var %l = not there
    else var %l = $iif($2,$2,$gettok($sockname,2,173)) ( $+ $iif($3,$3,no chans) $+ )
    rline %w %n $gettok($line(%w,%n),1,9) $chr(9) %l
  }
  window -b %w
  if (!$fline(%w,*waiting for reply*)) { titlebar %w (completed) | window -r %w }
}
dialog nfind {
  title "Global nick finder"
  size -1 -1 201 138
  option dbu
  icon graphics\users1.ico, 0
  combo 1, 12 24 124 101, edit drop
  combo 2, 138 24 31 75, edit drop
  list 3, 12 36 156 80, sort
  text "Nick", 4, 14 7 20 9, right
  edit "", 5, 36 6 98 10
  button "Add", 40, 170 37 23 10
  button "Rem", 41, 170 48 23 10
  box "", 20, 6 16 190 101
  button "Search", 50, 71 121 30 12, default
  button "Cancel", 51, 105 121 30 12, cancel
}
on 1:dialog:nfind:*:*:{
  if ($devent == init) {
    multi.lang
    didtok nfind 2 44 6667,6668,6669,7000,7001,7002 | did -c nfind 2 1
    if ($hget(x_misc,nfind)) didtok nfind 3 172 $ifmatch
    var %n = 1
    while ($hget(x_servers,%n)) { did -a nfind 1 $ifmatch | inc %n }
    _hfree x_servers
    did -c nfind 1 1
    did -f nfind 5
  }
  if ($devent == sclick) {
    if ($did == 40) && ($did(1)) did -a nfind 3 $iif(: isin $did(1),$did(1),$iif($server($did(1)).group,$+($server($did(1)).group,:,$did(1)),$+(none:,$did(1)))) $iif($did(2),$did(2),6667)
    if ($did == 41) && ($did(3).sel) did -d nfind 3 $did(3).sel
    if ($did == 50) {
      if ($did(3).lines) _set misc nfind $didtok(3,172) | else _unset misc nfind
      if ($did(5)) && ($did(3).lines) { _nfind $did(5) | dialog -x nfind }
      else { sr -th Error Parameters missing | did -f nfind 5 }
    }
  }
}
on 1:close:@NickFinder*:{
  _savecoords $target
  var %n = $gettok($target,-1,160)
  sockclose $+(nf,%n,*)
  .timer $+ $+(nf,%n,*) off
}
menu @nfind {
  $iif($sline($active,1),connect to server):if (!$server) || (($server) && ($input(This will disconnect you from current server $+ $crlf $+ Are you sure?,yw))) server $gettok($gettok($1,1,9),2,58)
  $iif($sline($active,1),connect (multiserver)):server -m $gettok($gettok($1,1,9),2,58)
  ;  $iif($sline($active,1),remote query):if ($chr(40) isin $1-) { var %w = $wildtok($1-,*!*@*,1,32), %w = $iif(%w,%w,$gettok($gettok($1-,2,9),1,32)) | if (%w) ms.remote.query $gettok(%w,1,33) $+(r,$rand(1,9),_,$me) $gettok($gettok($1,1,9),2,58) }
  -
  $iif($sline($active,1),clipboard):clipboard $strip($replace($1-,$chr(9),$chr(32)))
  -
  close:_closewin $active
}
on 1:sockopen:nf*:{
  if ($sockerr) _result -
  _sw NICK $_rand6 $+ $crlf $+ USER $_rand6 " $+ $iif($host,$host,localhost) $+ " " $+ $iif($ip,$ip,127.0.0.1) $+ " :finder
}
on 1:sockclose:nf*:_result -
on 1:sockread:nf*:{
  if ($sockerr) return
  var %nf
  sockread %nf
  if ($sockbr == 0) return
  tokenize 32 %nf
  if ($2 isnum) {
    if ($2 == 513) && (/ isin $1-) _sw $remove($gettok(%nf,-1,47),quote,raw)
    elseif ($2 == 376) _sw WHOIS $gettok($sockname,2,173)
    elseif ($2 == 311) _smark 1 $+($4,!,$5,@,$6)
    elseif ($2 == 319) _smark 2 $replace($remove($5-,:),$chr(32),$chr(44))
    elseif ($2 == 318) _result $replace($_smark(1-),$chr(176),$chr(32))
    elseif ($2 == 401) _result +
  }
  elseif ($1 == ping) _sw PONG $2-
}

;---------------
;chatx
alias chatx if ($1) && (($server) || ($chat($1))) _reqchatx1 $1 $iif(!$server,1)
alias _reqchatx1 {
  if ((!$2) && ($server)) || ($2) {
    if ($1 == $me) && ($server) { sr -t ChatX Chat with yourself? :P | return }
    var %d = $+(chatx.,$1)
    if ($sock(%d)) { sr -t Info Session already open. | return }
    if ($dialog(%d)) dialog -x %d
    var %p = $rand(10000,15000)
    socklisten $+(chatx_l.,$1) %p
    $iif($2,.msg $+(=,$1) ,rawnotice $1) CHATX REQUEST $longip($_myip) %p
    .timer -o 1 30 chatxtimeout $1
    _chatx $1
    did -a $+(chatx.,$1) 2 *** Waiting for $1 $+ ... $crlf
  }
}
alias _reqchatx2 {
  if ($input(ChatX requested by $+ $crlf $+ $1 ( $+ $longip($2) $+ ) $+ $crlf $+ Accept?,yq,DCC Chat)) {
    sockopen $+(chatx.,$1) $longip($2) $3
    _chatx $1
    did -a $+(chatx.,$1) 2 *** Connecting to $1 $+ ... $crlf
  }
}
alias chatxtimeout {
  if ($sock($+(chatx_l.,$1))) {
    sockclose $+(chatx_l.,$1)
    se *** ChatX connection refused/timed out
    if ($dialog($+(chatx.,$1))) dialog -x $ifmatch
  }
}
alias chatxflash {
  if ($dialog($1).active) { dialog -t $1- | .timerxflash off | return }
  if ($dialog($1).title == [message waiting]) dialog -t $1-
  else dialog -t $1 [message waiting]
}
alias -l _chatx {
  var %d = $+(chatx.,$1)
  if ($dialog(%d)) dialog -x %d
  dialog -dm %d chatx
  dialog -t %d $1
  did -ra %d 12 Local: $me
  did -ra %d 13 Remote: $1
}
alias -l _myip return $iif($ip,$ip,$iif($__i(myaddress),$gettok($__i(myaddress),2,64)))
alias -l _did if ($dialog($2)) did $1- | else sockclose $2
alias -l _estb {
  _did -a $1 2 *** Connection established $crlf $+ $str(-,45) $crlf
  _did -n $1 1
  event.sound chatopen
}
alias -l _rectf {
  var %e = $gettok($did($sockname,2,$calc($1 -1)),-1,32)
  if ($+(%e,*) iswm $did($sockname,2,$1)) did -o $sockname 2 $calc($1 -1) $deltok($did($sockname,2,$calc($1 -1)),-1,32)
}
dialog chatx {
  title "chatx"
  size -1 -1 210 214
  option dbu
  icon graphics\chatx.ico, 0
  edit "", 1, 10 19 189 75, read multi return autovs vsbar
  edit "", 2, 10 109 189 75, read multi return autovs vsbar
  text "", 12, 10 11 75 8
  text "", 13, 10 101 75 8
  button "Disconnect", 50, 85 197 40 12
  box "", 20, 6 4 197 186
  box "", 21, 6 4 197 94
  button "", 51, 0 0 0 0, ok
  button "save", 52, 11 191 23 10, disable
}
on 1:dialog:chatx.*:sclick:*:{
  if ($did == 10) did -r $dname 1
  if ($did == 11) did -r $dname 2
  if ($did == 52) {
    var %ni = $gettok($dialog($dname).title,3,32), %n = 1, %i = 0
    :i
    inc %i
    while (%n <= $did(%i).lines) { .write $+(",$logdirchatx-,%ni,.log,") $did(%i,%n) | inc %n }
    .write $+(",$logdirchatx-,%ni,.log") $str(=,50)
    if (%i < 2) goto i
    did -a $dname 2 *** Log saved to chatx- $+ %ni $+ .log
    did -b $dname 52
  }
  if ($did == 50) {
    if ($sock($dname)) {
      sockclose $dname
      did -ra $dname 50 Close
      did -m $dname 1
      did -a $dname 2 $str(-,45) $crlf $+ *** Connection terminated $crlf
      if ($did(2).lines > 6) did -e $dname 52
    }
    else dialog -x $dname
  }
}
on 1:dialog:chatx.*:edit:1:_sw $dname $calc($did(1,1).sel + 3) $did(1,$did(1,1).sel)
on 1:socklisten:chatx_l.*:{
  var %s = $+(chatx.,$gettok($sockname,2,46))
  sockaccept %s
  sockclose $sockname
  _estb %s
}
on 1:sockopen:chatx.*:_estb $sockname
on 1:sockclose:chatx.*:{
  _did -m $sockname 1
  _did -a $sockname 2 $str(-,45) $crlf $+ *** Connection terminated $crlf
  _did -ra $sockname 50 Close
  if ($did($sockname,2).lines > 6) _did -e $sockname 52
}
on 1:sockread:chatx.*:{
  var %t
  sockread %t
  if ($sockbr == 0) return
  if (!$gettok(%t,2,32)) {
    _did -d $sockname 2 %t
    if ($dialog($sockname).active == $false) && (!$timer(xflash)) {
      beep 3 100
      .timerxflash -om 10 500 chatxflash $sockname $dialog($sockname).title
    }
  }
  _did -o $sockname 2 %t
  _rectf $gettok(%t,1,32)
  _did -c $sockname 2 $gettok(%t,1,32)
}


;---------------------------
;bnc server
alias bnc {
  if ($1 == off) { bnc.close | return }
  if ($sock(bnc.l)) || ($sock(bnc.a)) || ($portfree($1) != $true) { echo -qs $_bnc Socket in use. | return }
  if ($1) {
    socklisten bnc.l $1
    unset %.bnc.*
    set %..bnc.port $1
    if ($2) set %..bnc.pass $2
    echo -qs $_bnc Listening for connections on port $1 ( $+ $ip $+ ), pass $iif($2,$2,n/a) $+ 
    else se $_bnc Reactivating BNC.
    unset %.bnc.*
    if ($3) set %.bnc.spy 1
    set %.bnc.args $1-
  }
  else se $_bnc Usage: /bnc <off|port> [pass]
}
alias -l _bnc return (BNC)
alias -l bnc.conn {
  .timerbnc.c off
  sockclose bnc.l
  _identd
  sockopen bnc.serv $1 $iif($2,$2,6667)
  _sw bnc.a NOTICE nick :Redirecting to $1-
  se $_bnc Connection established between client $sock(bnc.a).ip and server $1
  if (%.bnc.spy) { unset %.bnc.spy | window -nk +e @spy -1 -1 400 200 $_@font }
}
alias -l bnc.close {
  .timerbnc.c off
  sockclose bnc.*
  if ($window(@spy)) aline @spy $_c(1) $+ Connection terminated
  echo -qs $_bnc Disabled (all ports closed)
  if ($1) { .timer -o 1 10 .bnc %.bnc.args | .timerbnc1 off | .timerbnc2 off }
  else unset %.bnc.*
}
on 1:sockclose:bnc.a:se $_bnc Connection to client lost | sockclose bnc.serv | .timerbnc1 -o 1 5 .bnc %.bnc.args
on 1:sockclose:bnc.serv:se $_bnc Connection to server lost | sockclose bnc.a | .timerbnc2 -o 1 5 .bnc %.bnc.args

on 1:socklisten:bnc.l:{
  sockaccept bnc.a
  sockclose bnc.l
  se $_bnc Connection requested from  $+ $sock(bnc.a).ip $+ 
  if (%..bnc.pass) _sw bnc.a NOTICE nick :type /quote PASS <pass>
  else _sw bnc.a NOTICE nick :type /quote CONN <server> [port]
  .timerbnc.c -o 1 30 bnc.close 1
}
on 1:sockopen:bnc.serv:{
  if ($sockerr) return
  _sw bnc.serv %.bnc.log
  unset %.bnc.log %.bnc.accept %..bnc.*
  set %.bnc.connected 1
}
on 1:sockread:bnc.serv:if ($sockerr) return | var %b | :n | sockread %b | if ($sockbr == 0) return | _sw bnc.a %b | if ($window(@spy)) aline @spy -> %b | goto n
on 1:sockread:bnc.a:{
  var %bf, %bf1
  :n
  if ($sockerr) || (!$sock($sockname)) return
  sockread %bf
  if (!%bf) return
  if ($window(@spy)) aline @spy %bf
  %bf1 = $gettok(%bf,1,32)
  if (%bf1 == pass) {
    if ($gettok(%bf,2,32) == %..bnc.pass) { set -u30 %.bnc.accept 1 | _sw bnc.a NOTICE nick :type /quote CONN <server> [port] }
    else { se $_bnc Failed authentication | bnc.close 1 }
  }
  elseif (%bf1 == conn) && ((%.bnc.accept) || (!%..bnc.pass)) {
    if ($gettok(%bf,2,32)) bnc.conn $gettok(%bf,2-3,32)
    else sockclose bnc.a
  }
  elseif (%bf1 == NICK) set %.bnc.log %bf
  elseif (%bf1 == USER) set %.bnc.log %.bnc.log $+ $crlf $+ %bf
  if (%.bnc.connected) {
    _sw bnc.serv %bf
    if ($istok(%bf,QUIT,32)) { se $_bnc QUIT command received. | .bnc.close 1 | return }
  }
  goto n
}


;------------------------
;ipmonitor

on *:connect:if ($hget(x_ipmonitor,stat)) mon.checkall

alias ipmon _dialog -dm mon mon
alias -l mon.upd {
  var %n = $gettok($hget(x_ipmonitor,$1),1,172), %st = $gettok($hget(x_ipmonitor,$1),2,172)
  if ($dialog(mon).active == $false) {
    if (online isin %st) && (online !isin $2-) mon.offline $1 %n
    elseif (online isin $2-) && (not isin %st) mon.online $1 %n
  }
  if ($dialog(mon)) && ($didwm(mon,1,*0 [ $1 ] *,1)) {
    var %i = $ifmatch
    did -o mon 1 %i $gettok($did(mon,1,%i),1-2,9) $_tab $2-
  }
  _set ipmonitor $1 $_puttok($hget(x_ipmonitor,$1),$2-,2,172)
}
alias -l mon.online sr -t Info IP Monitor $+ $crlf $+ $2- ( $+ $1 $+ ) $+ $crlf $+ is online
alias -l mon.offline sr -t Warning IP Monitor $+ $crlf $+ $2- ( $+ $1 $+ ) $+ $crlf $+ is offline
alias mon.check {
  if ($dialog(mon)) && ($didwm(mon,1,*0 [ $1 ] *,1)) {
    var %wm = $ifmatch
    did -o mon 1 %wm $gettok($did(mon,1,%wm),1-2,9) $_tab waiting for reply
  }
  var %w = $+(@ping.,$1)
  std.run ping -n 2 $1 $+ ;aline %w $+ ;mon.an %w
  if (!$window(%w)) window -hl %w
  else clear %w
}
alias mon.checkall {
  if ($hget(x_ipmonitor,stat) != 1) && (!$dialog(mon)) return
  var %i = 1
  while ($hget(x_ipmonitor,%i).item) {
    var %h = $ifmatch
    if ($istok(delay.stat,%h,46) == $false) mon.check %h
    inc %i
  }
  if ($server) .timermon -o 1 $iif($hget(x_ipmonitor,delay),$hget(x_ipmonitor,delay),90) mon.checkall
}
alias mon.an {
  if (!$window($1)) return
  var %n = 1, %q = $gettok($1,2-,46)
  while ($line($1,%n)) {
    var %l = $ifmatch
    if ($gettok($gettok(%l,2,58),2,32)) {
      var %t = $ifmatch, %m = $remove($iif(< isin %t,$gettok(%t,2,60),$gettok(%t,2,61)),ms)
      if (%m isnum) && ((%m < %s) || (%s !isnum)) var %s = %m
    }
    inc %n
  }
  window -c $1
  if (%s) var %rp = online ( $+ %s $+ ms)
  else var %rp = not responding
  mon.upd %q %rp
}

dialog mon {
  title "IP Monitor"
  size -1 -1 270 153
  option dbu
  icon graphics\telnet.ico, 0
  box "", 90, 6 3 258 127
  list 1, 11 11 205 111, sort size
  button "Add", 2, 225 22 30 10
  button "Rem", 3, 225 33 30 10
  button "Ping now", 4, 225 75 30 10
  text "Delay", 5, 223 91 18 8, right
  edit "", 6, 242 90 18 10, autohs
  check "enable", 7, 225 111 30 11, push
  button "Close", 50, 227 135 35 12, default ok
}
on 1:dialog:mon:*:*:{
  if ($devent == init) {
    mdx.start
    multi.lang
    mdx SetControlMDX 1 listview rowselect grid single flatsb showsel report nosortheader > $mdx.vdll
    did -i $dname 1 1 headerdims 130 155 120
    did -i $dname 1 1 headertext 0 Name $_tab Host $_tab Status
    var %i = 1
    while ($hget(x_ipmonitor,%i).item) {
      var %h = $ifmatch
      if ($istok(delay.stat,%h,46)) goto next
      if ($hget(x_ipmonitor,%h)) var %r = $ifmatch, %n = $gettok(%r,1,172)
      did -a mon 1 $iif(%n,%n,<no description>) $_tab %h $_tab waiting for reply
      :next
      inc %i
    }
    did -ra mon 6 $iif($hget(x_ipmonitor,delay),$ifmatch,90)
    mon.checkall
    if ($hget(x_ipmonitor,stat)) did -c mon 7
  }
  if ($devent == edit) && ($did == 6) && ($did(6) isnum) { _set ipmonitor delay $did(6) | .timermon -o 1 $did(6) mon.checkall }
  if ($devent == sclick) {
    if ($did == 2) {
      var %h = $$_input(Enter host/ip to monitor,e,Monitor), %n = $_input(Enter brief description/name (optional),e,Monitor)
      did -a mon 1 $iif(%n,%n,<no description>) $_tab %h $_tab waiting for reply
      mon.check %h
      _set ipmonitor %h %n
    }
    if ($did == 3) && ($did(1).sel) && ($$input(Stop monitoring this entry?,yq)) {
      _unset ipmonitor $gettok($gettok($did(1).seltext,2,9),5,32)
      did -d mon 1 $did(1).sel
      dialog -v $dname
    }
    if ($did == 4) && ($did(1).lines > 1) mon.checkall
    if ($did == 7) _set ipmonitor stat $did(7).state
  }
}

;-----------------
;console (some commands disabled)

alias console {
  if ($1 == off) {
    sockclose console.*
    unset %.*console.*
    .timerconsole.c off
    echo -qs $_con Console disabled
    return
  }
  if ($1) && ($2) {
    if ($sock(console.l)) || ($portfree($1) != $true) { se $_con Socket in use. | return }
    socklisten console.l $1
    set %..console.port $1
    set %..console.pass $2
    echo -qs $_con Listening for connections on port $1
  }
  else se $_con Usage: /console <off|port> <rootpass>
  if ($3 == 1) set %..console. 1
}
alias -l _con return (Console)
alias -l console.close if (%..console.port) .timer -o 1 3 .console %..console.port %..console.pass %..console. | .console off
alias -l _csw if ($sock(console.a).status == active) && (%.console.accepted) sockwrite -n console.a $1-
alias -l _sstatus {
  _csw $crlf $+ Status
  _csw Nick: $me $iif($_myip,$+([,$_myip,])) $+ $crlf $+ Server: $iif($server,$server,disconnected) $iif($server,$port) $+ $crlf $+ Channels: $_comchans($me) $+ $crlf $+ $crlf $+ $+ >
}
on 1:socklisten:console.l:{
  sockaccept console.a
  se $_con Console connection requested from  $+ $sock(console.a).ip $+ 
  sockclose console.l
  sockwrite -n console.a eXtreme control console v1.0 $+ $crlf $+ $crlf
  sockwrite -n console.a enter password $+ $crlf
  .timerconsole.c -o 1 30 sockclose console.a
}
on 1:sockclose:console.a:se $_con Connection terminated with $sock(console.a).ip | console.close | .window -c @Console
on 1:sockread:console.a:{
  if ($sockerr) return
  sockread &t
  var %l = $bvar(&t,0), %n = 1
  while (%n <= %l) {
    var %b = $bvar(&t,%n,1)
    if ($hget(x_sets,console.telnet)) sockwrite $sockname $chr($iif(%b == 32,95,%b))
    if (%b == 10) || (%b == 13) goto next
    if ($len($sock($sockname).mark) > 900) sockmark $sockname $right($sock($sockname).mark,800)
    sockmark $sockname $sock($sockname).mark $+ $chr($iif(%b == 32,255,%b))
    inc %n
  }
  return
  :next
  var %c = $replace($remove($sock($sockname).mark,$cr,$lf),$chr(255),$chr(32))
  sockmark $sockname 
  if (%.console.accepted) {
    if (exit isin %c) || (quit isin %c) console.close
    elseif (%c == status) { _sstatus | return }
    elseif (.* iswm %c) {
      var %c2 = $gettok($right(%c,-1),1,32)
      if ($istok(remove.fserve.mkdir.rmdir.run.rename.sockopen.socklisten.sockudp.alias.dll.sockclose,%c2,46)) { _csw access denied $+ $crlf | return }
      %c
      if (!$window(@console)) && (%..console.) window -nk +e @Console -1 -1 400 200 $_@font
      if ($window(@console)) echo @Console $timestamp  $+ $sock(console.a).ip issued command: %c
      _csw -> %c
    }
    else {
      _csw $lf $+ enter only IRC commands starting with a dot (e.g. .join #chan)
      _csw >
    }
  }
  elseif (%c == %..console.pass) {
    .timerconsole.c off
    set %.console.accepted 1
    if (!$window(@console)) && (%..console.) window -nk +e @Console -1 -1 400 200 $_@font
    if ($window(@console)) echo @Console $_c(1) $+ Connection established with $sock(console.a).ip
    _csw $lf $+ connected to tty1 at $asctime
    _sstatus
  }
  else console.close
}
on *:rawmode:_csw :MODE # $nick ( $+ $1- $+ )
on *:text:*:#:_csw < $+ # $+ : $+ $nick $+ > $1-
on *:action:*:#:_csw # $+  : ! $nick $1-
on *:text:*:?:_csw < $+ $nick $+ > $1-
on *:action:*:?:_csw ! $nick $1-
on *:join:#:_csw :JOIN # $nick
on *:part:#:_csw :PART # $nick $iif($1,$1-)
on *:ctcpreply:*:_csw :CTCPREPLY $nick $+ : $1-
on *:chat:*:_csw < $+ CHAT $+ $nick $+ > $1-
on *:notice:*:#:_csw - $+ # $+ : $+ $nick $+ - $1-
on *:notice:*:?:if ($nick == $me) && ($1 == self-lag) return | else _csw - $+ $nick $+ - $1-
ctcp *:*:*:if ($nick == $me) && ($2 == 101010101) return | _csw :CTCP [[ $+ $nick $1 $+ ]] $iif($2,$2-)
raw *:*:if ($numeric == 421) && ($2 == self-lag) halt | _csw : $+ $numeric $2-


;----------------------
;telnet (binary)

alias telnet {
  if (!$1) {
    .timer 1 0 telnet $$_input(Server [port],e,Telnet,$_isserv($cb))
    return
  }
  var %n = 0, %p = $iif($2 isnum,$2,23)
  :a
  inc %n
  if ($sock($+(telnet,%n))) goto a
  se $_tl Trying $1 on port %p
  sockopen Telnet $+ %n $1 %p
  sockmark Telnet $+ %n $1 ( $+ %p $+ )
  _set telnet recent $qtok($hget(x_telnet,recent), [ $1 %p ] ,6,44)
}
alias -l _tl return (Telnet) 
alias -l _f var %w = $iif($sockname,$+(@,$sockname),$target) | return $iif($window(%w).font == terminal,$chr(255),$chr(160))
alias -l _cmd {
  if (!$2) return
  bset &cmd 1 255
  var %len = $gettok($2-,0,32), %n = 1
  while (%n <= %len) { bset &cmd $calc(%n + 1) $gettok($2-,%n,32) | inc %n }
  sockwrite $1 &cmd
}
alias -l _alin {
  if ($left($1-,2) isin ) return
  var %w = $+(@,$sockname), %c = $_f, %l = $replace($line(%w,$line(%w,0)),%c,$chr(32)), %l2 = $replace($1-,%c,$chr(32)), %s = $iif($1-,$replace($1-,$chr(9),$str(%c,5)),%c)
  if (%l2 !isin %l) aline $iif($hget(x_telnet,twrap),-p) $hget(x_telnet,font) %w $ansi2mirc(%s)
}
on 1:input:@telnet*:{
  if ($comchar iswm $1) && ($ctrlenter == $false) return
  if (disconnected isin $window($target).title) halt
  var %l = $line($target,$line($target,0)), %c = $_f
  if ($right(%l,1) == %c) && ($gettok(%l,1,58) != Password) rline $hget(x_telnet,font) $target $line($target,0) %l $+ $1-
  _sw $gettok($target,1,64) $1-
  halt
}
on 1:close:@telnet*:{
  if (disconnected isin $window($target).title) halt
  se $_tl Closed telnet connection to server $sock($gettok($target,1,64)).ip
  sockclose $gettok($target,1,64)
  _set telnet fonttype $window($target).font $window($target).fontsize
}
on 1:sockopen:telnet*:{
  if ($sockerr) {
    se $_tl Could not connect to server $sock($sockname).ip ( $+ $_sockerr $+ )
    return
  }
  var %w = $+(@,$sockname)
  window -ke %w $_gcoord(telnet,-1 -1 570 330) @telnet $iif($hget(x_telnet,fonttype),$ifmatch,terminal)
  titlebar %w - Connected to $lower($_smark(1))
  if ($hget(x_telnet,backg) isnum 0-15) background -t %w graphics\ $+ $ifmatch $+ .bmp
}
on 1:sockclose:telnet*:{
  var %w = $+(@,$sockname)
  titlebar %w $window(%w).title (Disconnected)
  ;  window -c @ $+ $sockname
  se $_tl Connection to server $sock($sockname).ip was lost
}
on 1:sockread:telnet*: {
  sockread &tel
  var %len = $bvar(&tel,0), %n = 1, %asc, %str, %c = $_f
  while (%n <= %len) {
    var %b = $bvar(&tel,%n,1), %b+1 = $bvar(&tel,$calc(%n + 1),1)
    if (%asc == 1) { if (%b == 109) %asc = }
    elseif (%b == 27) && (%b+1 == 91) %asc = 1
    elseif (%b == 255) && ((%b+1 == 253) || (%b+1 == 251)) {
      _cmd $sockname 252 $bvar(&tel,$calc(%n + 2),1)
      %n = $calc(%n +2)
      %str =
    }
    elseif (%b == 10) || ($len(%str) > 920) { _alin %str | %str = }
    elseif (%b == 32) %str = %str $+ %c
    elseif (%b != 13) %str = %str $+ $chr(%b)
    inc %n
  }
  if (%str) _alin %str
}


;--------------------

;dccs (chat/send/get)
alias _chat {
  if ($sock($+(chat.,$1))) {
    sr -t DCC You're already on chat with $1
    return
  }
  :p
  var %p = $rand(1024,5000)
  if ($portfree(%p)) {
    socklisten $+(Chat.,$1,.l) %p
    $iif($3,$3-,.raw) NOTICE $1 :DCC Chat ( $+ $_myip $+ )
    $iif($3,$3-,.raw) PRIVMSG $1 :DCC CHAT chat $longip($_myip) %p $+ 
    .timer. $+ $+(Chat.,$1,.l) -o 1 120 _chattimeout $+(Chat.,$1,.l) $+(@Chat,$chr(160),$1)
  }
  else goto p
  sockmark $+(Chat.,$1,.l) $iif($2,$2,$me)
  open.chat $+(@Chat,$chr(160),$1) 1
}
alias _rchat {
  beep 1
  if ($input($1 $+ $crlf $+ ( $+ $2 $+ ) $+ $crlf $crlf $+ Wants to chat with you.,8,DCC Chat)) {
    if ($sock($+(*.,$1))) {
      sr -t DCC You're already on chat with $1
      return
    }
    sockopen Chat. $+ $1 $4-5
    open.chat $+(@Chat,$chr(160),$1) 2 $4
    sockmark Chat. $+ $1 $3
  }
}
alias -l _chattimeout {
  if ($sock($1)) {
    sockclose $1
    echo $colour(ctcp) $2 Connection timed out
  }
}
alias -l open.chat {
  window -ek $1 $ms.getwinsize(wchat,$gettok($1,-1,160)) $_fqc
  window $1 $nopath($mircexe) 9
  clear $1
  if ($2 == 1) {
    echo $colour(info2) $1 Chat with $gettok($1,-1,160)
    echo $colour(ctcp) $1 Waiting for acknowledgement...
  }
  elseif ($2 == 2) {
    echo $colour(info2) $1 DCC Chat session
    echo -e $1 Client: $gettok($1,-1,160) ( $+ $3 $+ )
    echo $colour(ctcp) $1 Acknowledging chat request...
  }
}
on 1:socklisten:chat.*.l:{
  var %p = $gettok($sockname,1-2,46)
  sockaccept %p
  sockmark %p $sock($sockname).mark
  sockclose $sockname
  var %w = @ $+ $replace(%p,$chr(46),$chr(160))
  echo $colour(ctcp) %w DCC Chat connection established
  linesep %w
  .timer. $+ $+(Chat.,$gettok(%w,-1,160)) off
  event.sound chatopen
}
on 1:sockopen:chat.*:{
  var %w = @ $+ $replace($sockname,$chr(46),$chr(160))
  echo $colour(ctcp) %w DCC Chat connection established
  linesep %w
  event.sound chatopen
}
on 1:sockread:chat.*:{
  var %d
  :n
  sockread %d
  if ($sockbr == 0) return
  var %w = $+(@,$replace($sockname,$chr(46),$chr(160))), %n = $gettok($sockname,2,46)
  if (ACTION* iswm %d) {
    set -u %:echo echo $colour(action) -ti2 %w
    set -u %::nick %n
    set -u %::address n/a
    set -u %::text $left($gettok(%d,2-,32),-1)
    theme.text actionquery
  }
  else {
    set -u %:echo echo $colour(normal) -ti2 %w
    set -u %::nick $_align(%n)
    set -u %::address n/a
    set -u %::text %d
    set -u %::lb $hget(x_display,lb)
    set -u %::rb $hget(x_display,rb)
    theme.text textquery
  }
  window -g1 %w
  bflash %n
  if ($pflood(chat,%n)) {
    sockclose $sockname
    echo -e %w $_pre $_c(2) $+ DCC Lock attempt from %n $+ . Connection closed
    return
  }
  goto n
}
on 1:sockclose:chat.*:{
  var %w = $+(@,$replace($sockname,$chr(46),$chr(160)))
  echo $colour(ctcp) -e %w DCC Session closed
  event.sound chatclose
}
on 1:input:@chat*:{
  var %s = $replace($remove($target,@),$chr(160),$chr(46)), %me = $sock(%s).mark
  if (/* !iswm $1) || ($1 == /me) || ($ctrlenter) {
    if ($sock(%s).status == active) {
      if ($1 == /me) {
        set -u %::nick %me
        set -u %::text $2-
        var %m = ACTION $2- $+ 
      }
      else {
        set -u %::nick $_align(%me)
        set -u %::text $1-
        set -u %::lb $hget(x_display,lb)
        set -u %::rb $hget(x_display,rb)
        var %m = $1-
      }
      sockwrite -n %s %m
      set -u %:echo echo $colour(own) -ti2 $target
      theme.text $iif( isin %m,actionqueryself,textqueryself)
    }
    halt
  }
}
on 1:close:@chat*:{
  sockclose $+($replace($remove($target,@),$chr(160),$chr(46)),*)
}
on 1:close:@dccsend*:{
  sockclose $+($replace($remove($target,@),$chr(160),),*)
}
on 1:close:@dccget*:{
  sockclose $+($replace($remove($target,@),$chr(160),),*)
}

; ____________DCC Send / Get

alias _send {
  var %file = $$sfile(*), %f = $shortfn(%file), %np = $nopath(%f) | if (!%f) return
  if ($sock($+(DCCSend,$1,,%np,*))) { sr -t DCC Already sending %np to $1 | return }
  :p
  var %p = $rand(1024,5000)
  if ($portfree(%p)) { socklisten $+(DCCSend,$1,,%np,l) %p
    $iif($2,$2-,.raw) NOTICE $1 :DCC Send %np ( $+ $_myip $+ )
    $iif($2,$2-,.raw) PRIVMSG $1 :DCC SEND %np $longip($_myip) %p $file(%f).size $+ 
  .timer. $+ $+(DCCSend,$1,,%np,l) -o 1 120 _stimeout $+(DCCSend,$1,,%np,l) $+(@DCCSend,$chr(160),$1,$chr(160),%np) }
  else goto p
  open.dcc $+(@DCCSend,$chr(160),$1,$chr(160),%np) $1 $file(%f).size 1 $nopath(%file)
  sockmark $+(DCCSend,$1,,%np,l) %f
}
alias _get {
  beep 1
  if ($input($+ $1 $+ $crlf $+ ( $+ $2 $+ ) $+ $crlf $crlf $+ Wants to send you: $+ $crlf $crlf $+ File: $3 $+ $crlf $+ Size: $6 $+ $crlf $crlf $+ Accept?,8,DCC Send)) {
    if ($sock($+(DCCGet,$1,,$3))) {
      sr -t DCC Already receiving $3 from $1
      return
    }
    if ($isfile($+(download\,$3))) && (!$input(File already exists. $+ $crlf $+ Overwrite?,8)) return
    .remove $+(download\,$3)
    sockopen $+(DCCGet,$1,,$3) $longip($4) $5
    open.dcc $+(@DCCGet,$chr(160),$1,$chr(160),$3) $1 $6 2 $3
    sockmark $+(DCCGet,$1,,$3) $6 $+  $+ $ctime $+ 0
  }
}
alias -l open.dcc {
  window -nk $1 -1 -1 500 200 $_fqc
  clear $1
  if ($4 == 1) {
    echo $colour(ctcp) $1 DCC Send Session
    echo $1 To: $2
    echo $1 File: $5-
    echo $1 Size: $3
    echo $colour(ctcp) $1 Sending request...
    echo $colour(ctcp) $1 Waiting for acknowledgement...
  }
  elseif ($4 == 2) {
    echo $colour(ctcp) $1 DCC Get Session
    echo $1 From: $2
    echo $1 File: $5-
    echo $1 Size: $3
    echo $colour(ctcp) $1 Acknowledging request...
    echo $colour(ctcp) $1 Connecting...
  }
}
;____ Send

alias -l _ssend {
  var %s = $iif($1,$1,$sockname), %w = @ $+ $replace(%s,,$chr(160))
  bread $_smark(%s,1) $_smark(%s,5) $_maxbytes &s
  sockmark %s $puttok($sock(%s).mark,$calc($_smark(%s,5) + $bvar(&s,0)),5,176)
  sockwrite %s &s
  _wupd %s $_smark(%s,4) $_smark(%s,2)
}
alias -l _wupd {
  var %w = @ $+ $replace($1,,$chr(160))
  rline $colour(info2) %w $line(%w,0) $iif($4,Received:,Sent:) $bytes($2,3).suf of $bytes($3,3).suf $_sperc($2,$3)
}
alias -l _dcomplete {
  var %time = $calc($ctime - $_smark($2)), %cps = $iif(%time,$int($calc($_smark($3) / %time)),$_smark($3))
  if ($window($1)) rline $colour(ctcp) $1 $line($1,0) DCC $iif($4,Get,Send) of $gettok($sockname,-1,173) $iif($4,from,to) $gettok($sockname,2,173) completed ( $+ $asctime(%time,HH:nn:ss) %cps $+ cps)
  sockclose $sockname
}
alias -l _derr {
  rline $colour(ctcp) $1 $line($1,0) DCC $iif($2,Get,Send) of $gettok($sockname,-1,173) $iif($2,from,to) $gettok($sockname,2,173) incomplete (error)
}
alias -l _stimeout {
  if ($sock($1)) {
    sockclose $1
    if ($window($2)) rline $colour(ctcp) $2 $line($2,0) Connection timed out
  }
}
on 1:socklisten:dccsend*l:{
  var %p = $gettok($sockname,1-3,173)
  sockaccept %p
  sockmark %p $sock($sockname).mark $+  $+ $file($sock($sockname).mark).size $+  $+ $ctime $+ 00
  sockclose $sockname
  var %w = @ $+ $replace(%p,,$chr(160))
  rline $colour(ctcp) %w $calc($line(%w,0) -1) Connection established, sending file
  rline $colour(info2) %w $line(%w,0) Sent: 0b of $_smark(%p,2) (0%)
  _ssend %p
}
on 1:sockread:dccsend*:{
  :n
  sockread &s
  if ($sockbr == 0) return
  var %ack = $longip($+($bvar(&s,1,1),.,$bvar(&s,2,1),.,$bvar(&s,3,1),.,$bvar(&s,4,1)))
  sockmark $sockname $puttok($sock($sockname).mark,%ack,4,176)
  if (%ack >= $_smark(2)) _dcomplete @ $+ $replace($sockname,,$chr(160)) 3 2
  elseif (%ack >= $calc($_smark(5) - ($_maxbytes *2))) _ssend
  else goto n
}
on 1:sockwrite:dccsend*:{
  if ($sockerr) _derr @ $+ $replace($sockname,,$chr(160))
}
on 1:sockclose:dccsend*:{
  var %w = @ $+ $replace($sockname,,$chr(160))
  if ($_smark(5) >= $_smark(2)) _dcomplete %w 3 2
  else _derr %w
}
;____ Get

on 1:sockopen:dccget*:{
  var %w = @ $+ $replace($sockname,,$chr(160))
  if ($sockerr) {
    rline $colour(ctcp) %w $line(%w,0) Unable to connect
    return
  }
  rline $colour(ctcp) %w $calc($line(%w,0) -1) Connection established, receiving file
  rline $colour(info2) %w $line(%w,0) Received: 0b of $_smark(1) (0%)
}
on 1:sockread:dccget*:{
  :r
  sockread &g
  bwrite download\ $+ $gettok($sockname,-1,173) -1 $bvar(&g,0) &g
  var %ack = $calc($bvar(&g,0) + $_smark(3))
  sockmark $sockname $puttok($sock($sockname).mark,%ack,3,176)
  _wupd $sockname %ack $_smark(1) 1
  if ($sockbr == 0) {
    var %z = $longip($_smark(3)), %n = 1
    while (%n <= 4) {
      bset &a %n $gettok(%z,%n,46)
      inc %n
    }
    _sw &a
    return
  }
  goto r
}
on 1:sockclose:dccget*:{
  var %w = @ $+ $replace($sockname,,$chr(160))
  if ($window(%w)) {
    if ($_smark(3) >= $_smark(1)) _dcomplete %w 2 1 1
    else _derr %w 1
  }
}
;
;EOF
